/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.jackson.JacksonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class JacksonJsonpGenerator
implements jakarta.json.stream.JsonGenerator {
    private final JsonGenerator generator;

    public JacksonJsonpGenerator(JsonGenerator generator) {
        this.generator = generator;
    }

    public JsonGenerator jacksonGenerator() {
        return this.generator;
    }

    public jakarta.json.stream.JsonGenerator writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeStartObject(String name) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeStartArray(String name) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeKey(String name) {
        try {
            this.generator.writeFieldName(name);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, JsonValue value) {
        try {
            this.generator.writeFieldName(name);
            this.writeValue(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, String value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeString(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, BigInteger value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, BigDecimal value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, int value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, long value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, double value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, boolean value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeBooleanField(name, value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeNull(String name) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeEnd() {
        block4: {
            try {
                JsonStreamContext ctx = this.generator.getOutputContext();
                if (ctx.inObject()) {
                    this.generator.writeEndObject();
                    break block4;
                }
                if (ctx.inArray()) {
                    this.generator.writeEndArray();
                    break block4;
                }
                throw new JsonGenerationException("Unexpected context: '" + ctx.typeDesc() + "'");
            }
            catch (IOException e) {
                throw JacksonUtils.convertException(e);
            }
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(JsonValue value) {
        try {
            this.writeValue(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String value) {
        try {
            this.generator.writeString(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(BigDecimal value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(BigInteger value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(int value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(long value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(double value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(boolean value) {
        try {
            this.generator.writeBoolean(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
    }

    public void flush() {
        try {
            this.generator.flush();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
    }

    private void writeValue(JsonValue value) throws IOException {
        switch (value.getValueType()) {
            case OBJECT: {
                this.generator.writeStartObject();
                for (Map.Entry entry : value.asJsonObject().entrySet()) {
                    this.generator.writeFieldName((String)entry.getKey());
                    this.writeValue((JsonValue)entry.getValue());
                }
                this.generator.writeEndObject();
                break;
            }
            case ARRAY: {
                this.generator.writeStartArray();
                for (JsonValue item : value.asJsonArray()) {
                    this.writeValue(item);
                }
                this.generator.writeEndArray();
                break;
            }
            case STRING: {
                this.generator.writeString(((JsonString)value).getString());
                break;
            }
            case FALSE: {
                this.generator.writeBoolean(false);
                break;
            }
            case TRUE: {
                this.generator.writeBoolean(true);
                break;
            }
            case NULL: {
                this.generator.writeNull();
                break;
            }
            case NUMBER: {
                JsonNumber n = (JsonNumber)value;
                if (n.isIntegral()) {
                    this.generator.writeNumber(n.longValue());
                    break;
                }
                this.generator.writeNumber(n.doubleValue());
            }
        }
    }
}

