/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Logging
implements JsonpSerializable {
    @Nullable
    private final String level;
    private final String text;
    @Nullable
    private final String category;
    public static final JsonpDeserializer<Logging> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Logging::setupLoggingDeserializer);

    private Logging(Builder builder) {
        this.level = builder.level;
        this.text = ApiTypeHelper.requireNonNull(builder.text, this, "text");
        this.category = builder.category;
    }

    public static Logging of(Function<Builder, ObjectBuilder<Logging>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String level() {
        return this.level;
    }

    public final String text() {
        return this.text;
    }

    @Nullable
    public final String category() {
        return this.category;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.level != null) {
            generator.writeKey("level");
            generator.write(this.level);
        }
        generator.writeKey("text");
        generator.write(this.text);
        if (this.category != null) {
            generator.writeKey("category");
            generator.write(this.category);
        }
    }

    protected static void setupLoggingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::level, JsonpDeserializer.stringDeserializer(), "level");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::category, JsonpDeserializer.stringDeserializer(), "category");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Logging> {
        @Nullable
        private String level;
        private String text;
        @Nullable
        private String category;

        public final Builder level(@Nullable String value) {
            this.level = value;
            return this;
        }

        public final Builder text(String value) {
            this.text = value;
            return this;
        }

        public final Builder category(@Nullable String value) {
            this.category = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Logging build() {
            this._checkSingleUse();
            return new Logging(this);
        }
    }
}

