/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.Retries;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Status
implements JsonpSerializable {
    private final long batches;
    @Nullable
    private final String canceled;
    private final long created;
    private final long deleted;
    private final long noops;
    private final List<String> failures;
    private final float requestsPerSecond;
    private final Retries retries;
    @Nullable
    private final Time throttled;
    private final long throttledMillis;
    @Nullable
    private final Time throttledUntil;
    private final long throttledUntilMillis;
    @Nullable
    private final Boolean timedOut;
    @Nullable
    private final Long took;
    private final long total;
    private final long updated;
    private final long versionConflicts;
    public static final JsonpDeserializer<Status> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Status::setupStatusDeserializer);

    private Status(Builder builder) {
        this.batches = ApiTypeHelper.requireNonNull(builder.batches, this, "batches");
        this.canceled = builder.canceled;
        this.created = ApiTypeHelper.requireNonNull(builder.created, this, "created");
        this.deleted = ApiTypeHelper.requireNonNull(builder.deleted, this, "deleted");
        this.noops = ApiTypeHelper.requireNonNull(builder.noops, this, "noops");
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.requestsPerSecond = ApiTypeHelper.requireNonNull(builder.requestsPerSecond, this, "requestsPerSecond").floatValue();
        this.retries = ApiTypeHelper.requireNonNull(builder.retries, this, "retries");
        this.throttled = builder.throttled;
        this.throttledMillis = ApiTypeHelper.requireNonNull(builder.throttledMillis, this, "throttledMillis");
        this.throttledUntil = builder.throttledUntil;
        this.throttledUntilMillis = ApiTypeHelper.requireNonNull(builder.throttledUntilMillis, this, "throttledUntilMillis");
        this.timedOut = builder.timedOut;
        this.took = builder.took;
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.updated = ApiTypeHelper.requireNonNull(builder.updated, this, "updated");
        this.versionConflicts = ApiTypeHelper.requireNonNull(builder.versionConflicts, this, "versionConflicts");
    }

    public static Status of(Function<Builder, ObjectBuilder<Status>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long batches() {
        return this.batches;
    }

    @Nullable
    public final String canceled() {
        return this.canceled;
    }

    public final long created() {
        return this.created;
    }

    public final long deleted() {
        return this.deleted;
    }

    public final long noops() {
        return this.noops;
    }

    public final List<String> failures() {
        return this.failures;
    }

    public final float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public final Retries retries() {
        return this.retries;
    }

    @Nullable
    public final Time throttled() {
        return this.throttled;
    }

    public final long throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public final Time throttledUntil() {
        return this.throttledUntil;
    }

    public final long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    @Nullable
    public final Boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public final Long took() {
        return this.took;
    }

    public final long total() {
        return this.total;
    }

    public final long updated() {
        return this.updated;
    }

    public final long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("batches");
        generator.write(this.batches);
        if (this.canceled != null) {
            generator.writeKey("canceled");
            generator.write(this.canceled);
        }
        generator.writeKey("created");
        generator.write(this.created);
        generator.writeKey("deleted");
        generator.write(this.deleted);
        generator.writeKey("noops");
        generator.write(this.noops);
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (String item0 : this.failures) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("requests_per_second");
        generator.write((double)this.requestsPerSecond);
        generator.writeKey("retries");
        this.retries.serialize(generator, mapper);
        if (this.throttled != null) {
            generator.writeKey("throttled");
            this.throttled.serialize(generator, mapper);
        }
        generator.writeKey("throttled_millis");
        generator.write(this.throttledMillis);
        if (this.throttledUntil != null) {
            generator.writeKey("throttled_until");
            this.throttledUntil.serialize(generator, mapper);
        }
        generator.writeKey("throttled_until_millis");
        generator.write(this.throttledUntilMillis);
        if (this.timedOut != null) {
            generator.writeKey("timed_out");
            generator.write(this.timedOut.booleanValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.longValue());
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("updated");
        generator.write(this.updated);
        generator.writeKey("version_conflicts");
        generator.write(this.versionConflicts);
    }

    protected static void setupStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches");
        op.add(Builder::canceled, JsonpDeserializer.stringDeserializer(), "canceled");
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "failures");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::throttled, Time._DESERIALIZER, "throttled");
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntil, Time._DESERIALIZER, "throttled_until");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Status> {
        private Long batches;
        @Nullable
        private String canceled;
        private Long created;
        private Long deleted;
        private Long noops;
        @Nullable
        private List<String> failures;
        private Float requestsPerSecond;
        private Retries retries;
        @Nullable
        private Time throttled;
        private Long throttledMillis;
        @Nullable
        private Time throttledUntil;
        private Long throttledUntilMillis;
        @Nullable
        private Boolean timedOut;
        @Nullable
        private Long took;
        private Long total;
        private Long updated;
        private Long versionConflicts;

        public final Builder batches(long value) {
            this.batches = value;
            return this;
        }

        public final Builder canceled(@Nullable String value) {
            this.canceled = value;
            return this;
        }

        public final Builder created(long value) {
            this.created = value;
            return this;
        }

        public final Builder deleted(long value) {
            this.deleted = value;
            return this;
        }

        public final Builder noops(long value) {
            this.noops = value;
            return this;
        }

        public final Builder failures(List<String> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(String value, String ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder requestsPerSecond(float value) {
            this.requestsPerSecond = Float.valueOf(value);
            return this;
        }

        public final Builder retries(Retries value) {
            this.retries = value;
            return this;
        }

        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public final Builder throttled(@Nullable Time value) {
            this.throttled = value;
            return this;
        }

        public final Builder throttled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttled(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledMillis(long value) {
            this.throttledMillis = value;
            return this;
        }

        public final Builder throttledUntil(@Nullable Time value) {
            this.throttledUntil = value;
            return this;
        }

        public final Builder throttledUntil(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttledUntil(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledUntilMillis(long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public final Builder timedOut(@Nullable Boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder took(@Nullable Long value) {
            this.took = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder updated(long value) {
            this.updated = value;
            return this;
        }

        public final Builder versionConflicts(long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Status build() {
            this._checkSingleUse();
            return new Status(this);
        }
    }
}

