/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.RoleMappingRule;
import co.elastic.clients.elasticsearch.security.get_role.RoleTemplate;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleMapping
implements JsonpSerializable {
    private final boolean enabled;
    private final Map<String, JsonData> metadata;
    private final List<String> roles;
    private final RoleMappingRule rules;
    private final List<RoleTemplate> roleTemplates;
    public static final JsonpDeserializer<RoleMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleMapping::setupRoleMappingDeserializer);

    private RoleMapping(Builder builder) {
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
        this.metadata = ApiTypeHelper.unmodifiableRequired(builder.metadata, (Object)this, "metadata");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.rules = ApiTypeHelper.requireNonNull(builder.rules, this, "rules");
        this.roleTemplates = ApiTypeHelper.unmodifiable(builder.roleTemplates);
    }

    public static RoleMapping of(Function<Builder, ObjectBuilder<RoleMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final RoleMappingRule rules() {
        return this.rules;
    }

    public final List<RoleTemplate> roleTemplates() {
        return this.roleTemplates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("rules");
        this.rules.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.roleTemplates)) {
            generator.writeKey("role_templates");
            generator.writeStartArray();
            for (RoleTemplate roleTemplate : this.roleTemplates) {
                roleTemplate.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRoleMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::rules, RoleMappingRule._DESERIALIZER, "rules");
        op.add(Builder::roleTemplates, JsonpDeserializer.arrayDeserializer(RoleTemplate._DESERIALIZER), "role_templates");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RoleMapping> {
        private Boolean enabled;
        private Map<String, JsonData> metadata;
        private List<String> roles;
        private RoleMappingRule rules;
        @Nullable
        private List<RoleTemplate> roleTemplates;

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder rules(RoleMappingRule value) {
            this.rules = value;
            return this;
        }

        public final Builder rules(Function<RoleMappingRule.Builder, ObjectBuilder<RoleMappingRule>> fn) {
            return this.rules(fn.apply(new RoleMappingRule.Builder()).build());
        }

        public final Builder roleTemplates(List<RoleTemplate> list) {
            this.roleTemplates = Builder._listAddAll(this.roleTemplates, list);
            return this;
        }

        public final Builder roleTemplates(RoleTemplate value, RoleTemplate ... values) {
            this.roleTemplates = Builder._listAdd(this.roleTemplates, value, values);
            return this;
        }

        public final Builder roleTemplates(Function<RoleTemplate.Builder, ObjectBuilder<RoleTemplate>> fn) {
            return this.roleTemplates(fn.apply(new RoleTemplate.Builder()).build(), new RoleTemplate[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RoleMapping build() {
            this._checkSingleUse();
            return new RoleMapping(this);
        }
    }
}

