/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJobConfiguration;
import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJobStats;
import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJobStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RollupJob
implements JsonpSerializable {
    private final RollupJobConfiguration config;
    private final RollupJobStats stats;
    private final RollupJobStatus status;
    public static final JsonpDeserializer<RollupJob> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJob::setupRollupJobDeserializer);

    private RollupJob(Builder builder) {
        this.config = ApiTypeHelper.requireNonNull(builder.config, this, "config");
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static RollupJob of(Function<Builder, ObjectBuilder<RollupJob>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final RollupJobConfiguration config() {
        return this.config;
    }

    public final RollupJobStats stats() {
        return this.stats;
    }

    public final RollupJobStatus status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("config");
        this.config.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
    }

    protected static void setupRollupJobDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::config, RollupJobConfiguration._DESERIALIZER, "config");
        op.add(Builder::stats, RollupJobStats._DESERIALIZER, "stats");
        op.add(Builder::status, RollupJobStatus._DESERIALIZER, "status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RollupJob> {
        private RollupJobConfiguration config;
        private RollupJobStats stats;
        private RollupJobStatus status;

        public final Builder config(RollupJobConfiguration value) {
            this.config = value;
            return this;
        }

        public final Builder config(Function<RollupJobConfiguration.Builder, ObjectBuilder<RollupJobConfiguration>> fn) {
            return this.config(fn.apply(new RollupJobConfiguration.Builder()).build());
        }

        public final Builder stats(RollupJobStats value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<RollupJobStats.Builder, ObjectBuilder<RollupJobStats>> fn) {
            return this.stats(fn.apply(new RollupJobStats.Builder()).build());
        }

        public final Builder status(RollupJobStatus value) {
            this.status = value;
            return this;
        }

        public final Builder status(Function<RollupJobStatus.Builder, ObjectBuilder<RollupJobStatus>> fn) {
            return this.status(fn.apply(new RollupJobStatus.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RollupJob build() {
            this._checkSingleUse();
            return new RollupJob(this);
        }
    }
}

