/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Breaker
implements JsonpSerializable {
    @Nullable
    private final String estimatedSize;
    @Nullable
    private final Long estimatedSizeInBytes;
    @Nullable
    private final String limitSize;
    @Nullable
    private final Long limitSizeInBytes;
    @Nullable
    private final Float overhead;
    @Nullable
    private final Float tripped;
    public static final JsonpDeserializer<Breaker> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Breaker::setupBreakerDeserializer);

    private Breaker(Builder builder) {
        this.estimatedSize = builder.estimatedSize;
        this.estimatedSizeInBytes = builder.estimatedSizeInBytes;
        this.limitSize = builder.limitSize;
        this.limitSizeInBytes = builder.limitSizeInBytes;
        this.overhead = builder.overhead;
        this.tripped = builder.tripped;
    }

    public static Breaker of(Function<Builder, ObjectBuilder<Breaker>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String estimatedSize() {
        return this.estimatedSize;
    }

    @Nullable
    public final Long estimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }

    @Nullable
    public final String limitSize() {
        return this.limitSize;
    }

    @Nullable
    public final Long limitSizeInBytes() {
        return this.limitSizeInBytes;
    }

    @Nullable
    public final Float overhead() {
        return this.overhead;
    }

    @Nullable
    public final Float tripped() {
        return this.tripped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.estimatedSize != null) {
            generator.writeKey("estimated_size");
            generator.write(this.estimatedSize);
        }
        if (this.estimatedSizeInBytes != null) {
            generator.writeKey("estimated_size_in_bytes");
            generator.write(this.estimatedSizeInBytes.longValue());
        }
        if (this.limitSize != null) {
            generator.writeKey("limit_size");
            generator.write(this.limitSize);
        }
        if (this.limitSizeInBytes != null) {
            generator.writeKey("limit_size_in_bytes");
            generator.write(this.limitSizeInBytes.longValue());
        }
        if (this.overhead != null) {
            generator.writeKey("overhead");
            generator.write((double)this.overhead.floatValue());
        }
        if (this.tripped != null) {
            generator.writeKey("tripped");
            generator.write((double)this.tripped.floatValue());
        }
    }

    protected static void setupBreakerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::estimatedSize, JsonpDeserializer.stringDeserializer(), "estimated_size");
        op.add(Builder::estimatedSizeInBytes, JsonpDeserializer.longDeserializer(), "estimated_size_in_bytes");
        op.add(Builder::limitSize, JsonpDeserializer.stringDeserializer(), "limit_size");
        op.add(Builder::limitSizeInBytes, JsonpDeserializer.longDeserializer(), "limit_size_in_bytes");
        op.add(Builder::overhead, JsonpDeserializer.floatDeserializer(), "overhead");
        op.add(Builder::tripped, JsonpDeserializer.floatDeserializer(), "tripped");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Breaker> {
        @Nullable
        private String estimatedSize;
        @Nullable
        private Long estimatedSizeInBytes;
        @Nullable
        private String limitSize;
        @Nullable
        private Long limitSizeInBytes;
        @Nullable
        private Float overhead;
        @Nullable
        private Float tripped;

        public final Builder estimatedSize(@Nullable String value) {
            this.estimatedSize = value;
            return this;
        }

        public final Builder estimatedSizeInBytes(@Nullable Long value) {
            this.estimatedSizeInBytes = value;
            return this;
        }

        public final Builder limitSize(@Nullable String value) {
            this.limitSize = value;
            return this;
        }

        public final Builder limitSizeInBytes(@Nullable Long value) {
            this.limitSizeInBytes = value;
            return this;
        }

        public final Builder overhead(@Nullable Float value) {
            this.overhead = value;
            return this;
        }

        public final Builder tripped(@Nullable Float value) {
            this.tripped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Breaker build() {
            this._checkSingleUse();
            return new Breaker(this);
        }
    }
}

