/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.elasticsearch.ml.CategorizationAnalyzer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AnomalyDetectors
implements JsonpSerializable {
    private final CategorizationAnalyzer categorizationAnalyzer;
    private final int categorizationExamplesLimit;
    private final String modelMemoryLimit;
    private final int modelSnapshotRetentionDays;
    private final int dailyModelSnapshotRetentionAfterDays;
    public static final JsonpDeserializer<AnomalyDetectors> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnomalyDetectors::setupAnomalyDetectorsDeserializer);

    private AnomalyDetectors(Builder builder) {
        this.categorizationAnalyzer = ApiTypeHelper.requireNonNull(builder.categorizationAnalyzer, this, "categorizationAnalyzer");
        this.categorizationExamplesLimit = ApiTypeHelper.requireNonNull(builder.categorizationExamplesLimit, this, "categorizationExamplesLimit");
        this.modelMemoryLimit = ApiTypeHelper.requireNonNull(builder.modelMemoryLimit, this, "modelMemoryLimit");
        this.modelSnapshotRetentionDays = ApiTypeHelper.requireNonNull(builder.modelSnapshotRetentionDays, this, "modelSnapshotRetentionDays");
        this.dailyModelSnapshotRetentionAfterDays = ApiTypeHelper.requireNonNull(builder.dailyModelSnapshotRetentionAfterDays, this, "dailyModelSnapshotRetentionAfterDays");
    }

    public static AnomalyDetectors of(Function<Builder, ObjectBuilder<AnomalyDetectors>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final CategorizationAnalyzer categorizationAnalyzer() {
        return this.categorizationAnalyzer;
    }

    public final int categorizationExamplesLimit() {
        return this.categorizationExamplesLimit;
    }

    public final String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public final int modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public final int dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("categorization_analyzer");
        this.categorizationAnalyzer.serialize(generator, mapper);
        generator.writeKey("categorization_examples_limit");
        generator.write(this.categorizationExamplesLimit);
        generator.writeKey("model_memory_limit");
        generator.write(this.modelMemoryLimit);
        generator.writeKey("model_snapshot_retention_days");
        generator.write(this.modelSnapshotRetentionDays);
        generator.writeKey("daily_model_snapshot_retention_after_days");
        generator.write(this.dailyModelSnapshotRetentionAfterDays);
    }

    protected static void setupAnomalyDetectorsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::categorizationAnalyzer, CategorizationAnalyzer._DESERIALIZER, "categorization_analyzer");
        op.add(Builder::categorizationExamplesLimit, JsonpDeserializer.integerDeserializer(), "categorization_examples_limit");
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit");
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.integerDeserializer(), "model_snapshot_retention_days");
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.integerDeserializer(), "daily_model_snapshot_retention_after_days");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnomalyDetectors> {
        private CategorizationAnalyzer categorizationAnalyzer;
        private Integer categorizationExamplesLimit;
        private String modelMemoryLimit;
        private Integer modelSnapshotRetentionDays;
        private Integer dailyModelSnapshotRetentionAfterDays;

        public final Builder categorizationAnalyzer(CategorizationAnalyzer value) {
            this.categorizationAnalyzer = value;
            return this;
        }

        public final Builder categorizationAnalyzer(Function<CategorizationAnalyzer.Builder, ObjectBuilder<CategorizationAnalyzer>> fn) {
            return this.categorizationAnalyzer(fn.apply(new CategorizationAnalyzer.Builder()).build());
        }

        public final Builder categorizationExamplesLimit(int value) {
            this.categorizationExamplesLimit = value;
            return this;
        }

        public final Builder modelMemoryLimit(String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public final Builder modelSnapshotRetentionDays(int value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public final Builder dailyModelSnapshotRetentionAfterDays(int value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnomalyDetectors build() {
            this._checkSingleUse();
            return new AnomalyDetectors(this);
        }
    }
}

