/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetFiltersResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetFiltersRequest
extends RequestBase {
    private final List<String> filterId;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetFiltersRequest, GetFiltersResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetFiltersRequest, GetFiltersResponse>("es/ml.get_filters", request -> "GET", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.filterId())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetFiltersResponse._DESERIALIZER);

    private GetFiltersRequest(Builder builder) {
        this.filterId = ApiTypeHelper.unmodifiable(builder.filterId);
        this.from = builder.from;
        this.size = builder.size;
    }

    public static GetFiltersRequest of(Function<Builder, ObjectBuilder<GetFiltersRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> filterId() {
        return this.filterId;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetFiltersRequest> {
        @Nullable
        private List<String> filterId;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;

        public final Builder filterId(List<String> list) {
            this.filterId = Builder._listAddAll(this.filterId, list);
            return this;
        }

        public final Builder filterId(String value, String ... values) {
            this.filterId = Builder._listAdd(this.filterId, value, values);
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public GetFiltersRequest build() {
            this._checkSingleUse();
            return new GetFiltersRequest(this);
        }
    }
}

