/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeAnalysisRegression
extends DataframeAnalysisBase
implements DataframeAnalysisVariant {
    @Nullable
    private final String lossFunction;
    @Nullable
    private final Double lossFunctionParameter;
    public static final JsonpDeserializer<DataframeAnalysisRegression> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisRegression::setupDataframeAnalysisRegressionDeserializer);

    private DataframeAnalysisRegression(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
        this.lossFunctionParameter = builder.lossFunctionParameter;
    }

    public static DataframeAnalysisRegression of(Function<Builder, ObjectBuilder<DataframeAnalysisRegression>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeAnalysis.Kind _dataframeAnalysisKind() {
        return DataframeAnalysis.Kind.Regression;
    }

    @Nullable
    public final String lossFunction() {
        return this.lossFunction;
    }

    @Nullable
    public final Double lossFunctionParameter() {
        return this.lossFunctionParameter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lossFunction != null) {
            generator.writeKey("loss_function");
            generator.write(this.lossFunction);
        }
        if (this.lossFunctionParameter != null) {
            generator.writeKey("loss_function_parameter");
            generator.write(this.lossFunctionParameter.doubleValue());
        }
    }

    protected static void setupDataframeAnalysisRegressionDeserializer(ObjectDeserializer<Builder> op) {
        DataframeAnalysisBase.setupDataframeAnalysisBaseDeserializer(op);
        op.add(Builder::lossFunction, JsonpDeserializer.stringDeserializer(), "loss_function");
        op.add(Builder::lossFunctionParameter, JsonpDeserializer.doubleDeserializer(), "loss_function_parameter");
    }

    public static class Builder
    extends DataframeAnalysisBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeAnalysisRegression> {
        @Nullable
        private String lossFunction;
        @Nullable
        private Double lossFunctionParameter;

        public final Builder lossFunction(@Nullable String value) {
            this.lossFunction = value;
            return this;
        }

        public final Builder lossFunctionParameter(@Nullable Double value) {
            this.lossFunctionParameter = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalysisRegression build() {
            this._checkSingleUse();
            return new DataframeAnalysisRegression(this);
        }
    }
}

