/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.elasticsearch.indices.stats.ShardLease;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ShardRetentionLeases
implements JsonpSerializable {
    private final long primaryTerm;
    private final long version;
    private final List<ShardLease> leases;
    public static final JsonpDeserializer<ShardRetentionLeases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRetentionLeases::setupShardRetentionLeasesDeserializer);

    private ShardRetentionLeases(Builder builder) {
        this.primaryTerm = ApiTypeHelper.requireNonNull(builder.primaryTerm, this, "primaryTerm");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.leases = ApiTypeHelper.unmodifiableRequired(builder.leases, (Object)this, "leases");
    }

    public static ShardRetentionLeases of(Function<Builder, ObjectBuilder<ShardRetentionLeases>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long primaryTerm() {
        return this.primaryTerm;
    }

    public final long version() {
        return this.version;
    }

    public final List<ShardLease> leases() {
        return this.leases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("version");
        generator.write(this.version);
        if (ApiTypeHelper.isDefined(this.leases)) {
            generator.writeKey("leases");
            generator.writeStartArray();
            for (ShardLease item0 : this.leases) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupShardRetentionLeasesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "primary_term");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::leases, JsonpDeserializer.arrayDeserializer(ShardLease._DESERIALIZER), "leases");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardRetentionLeases> {
        private Long primaryTerm;
        private Long version;
        private List<ShardLease> leases;

        public final Builder primaryTerm(long value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder leases(List<ShardLease> list) {
            this.leases = Builder._listAddAll(this.leases, list);
            return this;
        }

        public final Builder leases(ShardLease value, ShardLease ... values) {
            this.leases = Builder._listAdd(this.leases, value, values);
            return this;
        }

        public final Builder leases(Function<ShardLease.Builder, ObjectBuilder<ShardLease>> fn) {
            return this.leases(fn.apply(new ShardLease.Builder()).build(), new ShardLease[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardRetentionLeases build() {
            this._checkSingleUse();
            return new ShardRetentionLeases(this);
        }
    }
}

