/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardQueryCache
implements JsonpSerializable {
    private final long cacheCount;
    private final long cacheSize;
    private final long evictions;
    private final long hitCount;
    private final long memorySizeInBytes;
    private final long missCount;
    private final long totalCount;
    public static final JsonpDeserializer<ShardQueryCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardQueryCache::setupShardQueryCacheDeserializer);

    private ShardQueryCache(Builder builder) {
        this.cacheCount = ApiTypeHelper.requireNonNull(builder.cacheCount, this, "cacheCount");
        this.cacheSize = ApiTypeHelper.requireNonNull(builder.cacheSize, this, "cacheSize");
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
        this.hitCount = ApiTypeHelper.requireNonNull(builder.hitCount, this, "hitCount");
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, this, "memorySizeInBytes");
        this.missCount = ApiTypeHelper.requireNonNull(builder.missCount, this, "missCount");
        this.totalCount = ApiTypeHelper.requireNonNull(builder.totalCount, this, "totalCount");
    }

    public static ShardQueryCache of(Function<Builder, ObjectBuilder<ShardQueryCache>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long cacheCount() {
        return this.cacheCount;
    }

    public final long cacheSize() {
        return this.cacheSize;
    }

    public final long evictions() {
        return this.evictions;
    }

    public final long hitCount() {
        return this.hitCount;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final long missCount() {
        return this.missCount;
    }

    public final long totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_count");
        generator.write(this.cacheCount);
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    protected static void setupShardQueryCacheDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheCount, JsonpDeserializer.longDeserializer(), "cache_count");
        op.add(Builder::cacheSize, JsonpDeserializer.longDeserializer(), "cache_size");
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
        op.add(Builder::missCount, JsonpDeserializer.longDeserializer(), "miss_count");
        op.add(Builder::totalCount, JsonpDeserializer.longDeserializer(), "total_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardQueryCache> {
        private Long cacheCount;
        private Long cacheSize;
        private Long evictions;
        private Long hitCount;
        private Long memorySizeInBytes;
        private Long missCount;
        private Long totalCount;

        public final Builder cacheCount(long value) {
            this.cacheCount = value;
            return this;
        }

        public final Builder cacheSize(long value) {
            this.cacheSize = value;
            return this;
        }

        public final Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        public final Builder hitCount(long value) {
            this.hitCount = value;
            return this;
        }

        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public final Builder missCount(long value) {
            this.missCount = value;
            return this;
        }

        public final Builder totalCount(long value) {
            this.totalCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardQueryCache build() {
            this._checkSingleUse();
            return new ShardQueryCache(this);
        }
    }
}

