/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_data_stream.IndicesGetDataStreamItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetDataStreamResponse
implements JsonpSerializable {
    private final List<IndicesGetDataStreamItem> dataStreams;
    public static final JsonpDeserializer<GetDataStreamResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataStreamResponse::setupGetDataStreamResponseDeserializer);

    private GetDataStreamResponse(Builder builder) {
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
    }

    public static GetDataStreamResponse of(Function<Builder, ObjectBuilder<GetDataStreamResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<IndicesGetDataStreamItem> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (IndicesGetDataStreamItem item0 : this.dataStreams) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetDataStreamResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(IndicesGetDataStreamItem._DESERIALIZER), "data_streams");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetDataStreamResponse> {
        private List<IndicesGetDataStreamItem> dataStreams;

        public final Builder dataStreams(List<IndicesGetDataStreamItem> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(IndicesGetDataStreamItem value, IndicesGetDataStreamItem ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder dataStreams(Function<IndicesGetDataStreamItem.Builder, ObjectBuilder<IndicesGetDataStreamItem>> fn) {
            return this.dataStreams(fn.apply(new IndicesGetDataStreamItem.Builder()).build(), new IndicesGetDataStreamItem[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataStreamResponse build() {
            this._checkSingleUse();
            return new GetDataStreamResponse(this);
        }
    }
}

