/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class FieldMapping
implements JsonpSerializable {
    private final String field;
    private final String fullName;
    private final Map<String, Property> mapping;
    public static final JsonpDeserializer<FieldMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldMapping::setupFieldMappingDeserializer);

    private FieldMapping(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.fullName = ApiTypeHelper.requireNonNull(builder.fullName, this, "fullName");
        this.mapping = ApiTypeHelper.unmodifiableRequired(builder.mapping, (Object)this, "mapping");
    }

    public static FieldMapping of(Function<Builder, ObjectBuilder<FieldMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final String fullName() {
        return this.fullName;
    }

    public final Map<String, Property> mapping() {
        return this.mapping;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        generator.writeKey("full_name");
        generator.write(this.fullName);
        if (ApiTypeHelper.isDefined(this.mapping)) {
            generator.writeKey("mapping");
            generator.writeStartObject();
            for (Map.Entry<String, Property> item0 : this.mapping.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupFieldMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(Builder::mapping, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "mapping");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldMapping> {
        private String field;
        private String fullName;
        private Map<String, Property> mapping;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder fullName(String value) {
            this.fullName = value;
            return this;
        }

        public final Builder mapping(Map<String, Property> map) {
            this.mapping = Builder._mapPutAll(this.mapping, map);
            return this;
        }

        public final Builder mapping(String key, Property value) {
            this.mapping = Builder._mapPut(this.mapping, key, value);
            return this;
        }

        public final Builder mapping(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.mapping(key, fn.apply(new Property.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldMapping build() {
            this._checkSingleUse();
            return new FieldMapping(this);
        }
    }
}

