/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.ArrayPercentilesItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Percentiles
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Percentiles> _DESERIALIZER = JsonpDeserializer.lazy(Percentiles::buildPercentilesDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Percentiles(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Percentiles(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Percentiles of(Function<Builder, ObjectBuilder<Percentiles>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isArray() {
        return this._kind == Kind.Array;
    }

    public List<ArrayPercentilesItem> array() {
        return (List)TaggedUnionUtils.get(this, Kind.Array);
    }

    public boolean isKeyed() {
        return this._kind == Kind.Keyed;
    }

    public Map<String, String> keyed() {
        return (Map)TaggedUnionUtils.get(this, Kind.Keyed);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Array: {
                    generator.writeStartArray();
                    for (ArrayPercentilesItem item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Keyed: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        generator.write((String)item0.getValue());
                    }
                    generator.writeEnd();
                }
            }
        }
    }

    private static JsonpDeserializer<Percentiles> buildPercentilesDeserializer() {
        return new UnionDeserializer.Builder<Percentiles, Kind, Object>(Percentiles::new, false).addMember(Kind.Array, JsonpDeserializer.arrayDeserializer(ArrayPercentilesItem._DESERIALIZER)).addMember(Kind.Keyed, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Percentiles> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Percentiles> array(List<ArrayPercentilesItem> v) {
            this._kind = Kind.Array;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Percentiles> keyed(Map<String, String> v) {
            this._kind = Kind.Keyed;
            this._value = v;
            return this;
        }

        @Override
        public Percentiles build() {
            this._checkSingleUse();
            return new Percentiles(this);
        }
    }

    public static enum Kind {
        Array,
        Keyed;

    }
}

