/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.utils;

import cn.org.bjca.seal.esspdf.client.utils.ClientUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;

public class JsonMapper {
    private ObjectMapper mapper = new ObjectMapper();

    public JsonMapper() {
        this(null);
    }

    public JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static JsonMapper nonEmptyMapper() {
        return new JsonMapper(JsonInclude.Include.NON_EMPTY);
    }

    public static JsonMapper nonDefaultMapper() {
        return new JsonMapper(JsonInclude.Include.NON_DEFAULT);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            System.out.println("write to json string error:" + object);
            e.printStackTrace();
            return null;
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (ClientUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            System.out.println("parse json string error:" + jsonString);
            e.printStackTrace();
            return null;
        }
    }

    public <T> T fromJson(String jsonString, JavaType javaType) {
        if (ClientUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            System.out.println("parse json string error:" + jsonString);
            e.printStackTrace();
            return null;
        }
    }

    public JavaType createCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return this.mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public <T> T update(String jsonString, T object) {
        try {
            return (T)this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            System.out.println("update json string:" + jsonString + " to object:" + object + " error.");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("update json string:" + jsonString + " to object:" + object + " error.");
            e.printStackTrace();
        }
        return null;
    }

    public String toJsonP(String functionName, Object object) {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public void enableEnumUseToString() {
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    public void enableJaxbAnnotation() {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.mapper.registerModule((Module)module);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

