/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import sun.misc.BASE64Encoder;

public class ClientUtil {
    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !ClientUtil.isBlank(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        InputStream in = null;
        try {
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new IOException("File '" + file + "' exists but is a directory");
                }
                if (!file.canRead()) {
                    throw new IOException("File '" + file + "' cannot be read");
                }
            } else {
                throw new FileNotFoundException("File '" + file + "' does not exist");
            }
            in = new FileInputStream(file);
            byte[] byArray = ClientUtil.toByteArray(in, file.length());
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static byte[] toByteArray(InputStream input, long fileSize) throws IOException {
        int offset;
        int readed;
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + fileSize);
        }
        int size = (int)fileSize;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (readed = input.read(data, offset, size - offset)) != -1; offset += readed) {
        }
        if (offset != size) {
            throw new IOException("Unexpected readed size. current: " + offset + ", excepted: " + size);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileOutputStream out = null;
        try {
            out = ClientUtil.openOutputStream(file, false);
            ((OutputStream)out).write(data);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readBytesToX509Certificate(byte[] certBty) throws Exception {
        X509Certificate certObj = null;
        BufferedReader bufRdr = null;
        try {
            bufRdr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certBty)));
            String beginKey = "-----BEGIN CERTIFICATE-----\n";
            String endKey = "-----END CERTIFICATE-----";
            String certStr = bufRdr.readLine();
            if (certStr != null && !certStr.startsWith("-----") && !certStr.startsWith("0")) {
                beginKey = beginKey + certStr + "\n";
                while ((certStr = bufRdr.readLine()) != null) {
                    beginKey = beginKey + certStr + "\n";
                }
                beginKey = beginKey + endKey;
                certBty = beginKey.getBytes();
            }
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            certObj = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBty));
        }
        finally {
            if (bufRdr != null) {
                bufRdr.close();
            }
        }
        return certObj;
    }

    public static String digestSHA1(String decript) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(decript.getBytes("UTF-8"));
            byte[] messageDigest = digest.digest();
            BASE64Encoder base64 = new BASE64Encoder();
            return base64.encode(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

