/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ArrayUtil {
    public static byte[] replace(byte[] org, byte[] search, byte[] replace, int startIndex) throws UnsupportedEncodingException {
        int index = ArrayUtil.indexOf(org, search, startIndex);
        if (index != -1) {
            int newLength = org.length + replace.length - search.length;
            byte[] newByte = new byte[newLength];
            System.arraycopy(org, 0, newByte, 0, index);
            System.arraycopy(replace, 0, newByte, index, replace.length);
            System.arraycopy(org, index + search.length, newByte, index + replace.length, org.length - index - search.length);
            int newStart = index + replace.length;
            if (newByte.length - newStart > replace.length) {
                return ArrayUtil.replace(newByte, search, replace, newStart);
            }
            return newByte;
        }
        return org;
    }

    public static byte[] mergeArray(byte[] org, byte[] append) {
        byte[] newByte = new byte[org.length + append.length];
        System.arraycopy(org, 0, newByte, 0, org.length);
        System.arraycopy(append, 0, newByte, org.length, append.length);
        return newByte;
    }

    public static void replaceSubArray(byte[] org, int index, byte[] append) {
        System.arraycopy(append, 0, org, index, append.length);
    }

    public static byte[] subArray(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] subArray(byte[] original, int from) {
        int newLength = original.length - from;
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] char2byte(String conding, char ... chars) {
        Charset cs = Charset.forName(conding);
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }

    public static int indexOf(byte[] org, byte[] search) {
        return ArrayUtil.indexOf(org, search, 0);
    }

    public static int indexOf(byte[] org, byte[] search, int startIndex) {
        KMPMatcher kmpMatcher = new KMPMatcher();
        kmpMatcher.computeFailure4Byte(search);
        return kmpMatcher.indexOf(org, startIndex);
    }

    public static int lastIndexOf(byte[] org, byte[] search) {
        return ArrayUtil.lastIndexOf(org, search, 0);
    }

    public static int lastIndexOf(byte[] org, byte[] search, int fromIndex) {
        KMPMatcher kmpMatcher = new KMPMatcher();
        kmpMatcher.computeFailure4Byte(search);
        return kmpMatcher.lastIndexOf(org, fromIndex);
    }

    static class KMPMatcher {
        private int[] failure;
        private int matchPoint;
        private byte[] bytePattern;

        KMPMatcher() {
        }

        public int indexOf(byte[] text, int startIndex) {
            int j = 0;
            if (text.length == 0 || startIndex > text.length) {
                return -1;
            }
            for (int i = startIndex; i < text.length; ++i) {
                while (j > 0 && this.bytePattern[j] != text[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == text[i]) {
                    ++j;
                }
                if (j != this.bytePattern.length) continue;
                this.matchPoint = i - this.bytePattern.length + 1;
                return this.matchPoint;
            }
            return -1;
        }

        public int lastIndexOf(byte[] text, int startIndex) {
            this.matchPoint = -1;
            int j = 0;
            if (text.length == 0 || startIndex > text.length) {
                return -1;
            }
            int end = text.length;
            for (int i = startIndex; i < end; ++i) {
                while (j > 0 && this.bytePattern[j] != text[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == text[i]) {
                    ++j;
                }
                if (j == this.bytePattern.length) {
                    this.matchPoint = i - this.bytePattern.length + 1;
                    if (text.length - i > this.bytePattern.length) {
                        j = 0;
                        continue;
                    }
                    return this.matchPoint;
                }
                if (startIndex == 0 || i + 1 != end) continue;
                end = startIndex;
                i = -1;
                startIndex = 0;
            }
            return this.matchPoint;
        }

        public int lastIndexOfWithNoLoop(byte[] text, int startIndex) {
            this.matchPoint = -1;
            int j = 0;
            if (text.length == 0 || startIndex > text.length) {
                return -1;
            }
            for (int i = startIndex; i < text.length; ++i) {
                while (j > 0 && this.bytePattern[j] != text[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == text[i]) {
                    ++j;
                }
                if (j != this.bytePattern.length) continue;
                this.matchPoint = i - this.bytePattern.length + 1;
                if (text.length - i > this.bytePattern.length) {
                    j = 0;
                    continue;
                }
                return this.matchPoint;
            }
            return this.matchPoint;
        }

        public void computeFailure4Byte(byte[] patternStr) {
            this.bytePattern = patternStr;
            int j = 0;
            int len = this.bytePattern.length;
            this.failure = new int[len];
            for (int i = 1; i < len; ++i) {
                while (j > 0 && this.bytePattern[j] != this.bytePattern[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == this.bytePattern[i]) {
                    // empty if block
                }
                this.failure[i] = ++j;
            }
        }
    }
}

