/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.tools;

import cn.org.bjca.seal.esspdf.client.commons.InetAddressSingle;
import cn.org.bjca.seal.esspdf.client.message.BusinessInfo;
import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import cn.org.bjca.seal.esspdf.client.message.ClientSignMessage;
import cn.org.bjca.seal.esspdf.client.message.RectangleBean;
import cn.org.bjca.seal.esspdf.client.message.ReqMessage;
import cn.org.bjca.seal.esspdf.client.tools.BaseClientTool;
import cn.org.bjca.seal.esspdf.client.utils.ClientUtil;
import java.util.List;
import sun.misc.BASE64Encoder;

public class ESSPDFFrontClientTool
extends BaseClientTool {
    public ESSPDFFrontClientTool(String ip, int port) throws Exception {
        this.ip = ip;
        this.port = port;
    }

    public ESSPDFFrontClientTool(String ... inetAddress) throws Exception {
        if (inetAddress.length > 1) {
            InetAddressSingle.getInstance(inetAddress);
            this.isConnections = true;
        } else {
            String[] dd = inetAddress[0].split(":");
            this.ip = dd[0];
            this.port = Integer.valueOf(dd[1]);
        }
    }

    public ChannelMessage pdfSign(String ruleNum, BusinessInfo businessInfo, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setBusinessInfo(businessInfo);
        reqMessage.setType("1");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSign(List<String> ruleNumList, BusinessInfo businessInfo, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ruleNumList == null || ruleNumList.size() == 0 || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNumList.get(0));
        ruleNumList.remove(0);
        reqMessage.setRuleNumList(ruleNumList);
        reqMessage.setType("1");
        reqMessage.setBusinessInfo(businessInfo);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByParam(byte[] pdfBty, BusinessInfo businessInfo, List<ClientSignMessage> clientSignMessages) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || clientSignMessages == null || clientSignMessages.size() == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setBusinessInfo(businessInfo);
        reqMessage.setType("35");
        reqMessage.setClientSignMessages(clientSignMessages);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByParam(byte[] pdfBty, BusinessInfo businessInfo, byte[] sealBty, float sealWidth, float sealHeight, String certSN, boolean isPrintSeal, RectangleBean bean) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || sealBty == null || sealBty.length == 0 || ClientUtil.isBlank(certSN) || bean == null) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(certSN.toUpperCase());
        reqMessage.setSealWidth(sealWidth);
        reqMessage.setSealHeight(sealHeight);
        reqMessage.setType("28");
        reqMessage.setTemplateNum("" + isPrintSeal);
        reqMessage.setContents("" + bean.getPageNo() + "##" + bean.getLeft() + "##" + bean.getTop() + "##" + bean.getRight() + "##" + bean.getBottom());
        reqMessage.setSealImg(new String(new BASE64Encoder().encode(sealBty)));
        reqMessage.setBusinessInfo(businessInfo);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSpeedSign(List<String> ruleNumList, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ruleNumList == null || ruleNumList.size() == 0 || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNumList.get(0));
        ruleNumList.remove(0);
        reqMessage.setRuleNumList(ruleNumList);
        reqMessage.setType("5");
        ChannelMessage mes = this.tcpTransport(reqMessage, pdfBty);
        if ("200".equals(mes.getStatusCode())) {
            int i = pdfBty.length;
            byte[] signDataBty = mes.getBody();
            int j = signDataBty.length;
            byte[] all = new byte[i + j];
            System.arraycopy(pdfBty, 0, all, 0, i);
            System.arraycopy(signDataBty, 0, all, i, j);
            mes.setBodyLength(all.length);
            mes.setBody(all);
        }
        return mes;
    }

    public ChannelMessage pdfVerify(byte[] pdfSignBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfSignBty == null || pdfSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("2");
        return this.tcpTransport(reqMessage, pdfSignBty);
    }
}

