/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.tools;

import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import cn.org.bjca.seal.esspdf.client.message.ClientSignBean;
import cn.org.bjca.seal.esspdf.client.message.ClientSignMessage;
import cn.org.bjca.seal.esspdf.client.tools.AnySignClientTool;
import cn.org.bjca.seal.esspdf.client.utils.ClientUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ESSPDFClientCommandTool {
    public static void main(String[] args) throws Exception {
        String reqType = args[2];
        if (reqType.equals("1")) {
            ESSPDFClientCommandTool.pdfSign(args);
        } else if (reqType.equals("2")) {
            ESSPDFClientCommandTool.pdfVerify(args);
        } else if (reqType.equals("14")) {
            ESSPDFClientCommandTool.genClientSignDigest(args);
        } else if (reqType.equals("15")) {
            ESSPDFClientCommandTool.genClientSign(args);
        } else if (reqType.equals("12")) {
            ESSPDFClientCommandTool.pdfSignByWord(args);
        } else {
            throw new Exception("reqType error");
        }
    }

    private static void pdfSign(String[] args) throws IOException, Exception {
        String ip = args[0];
        int port = Integer.valueOf(args[1]);
        String ruleNumArray = args[3];
        String inputFilePath = args[4];
        String outputFilePath = args[5];
        ArrayList<String> ruleNumList = new ArrayList<String>();
        String[] ruleNums = ruleNumArray.split("#");
        for (int i = 0; i < ruleNums.length; ++i) {
            ruleNumList.add(ruleNums[i]);
        }
        byte[] pdfBty = ClientUtil.readFileToByteArray(new File(inputFilePath));
        AnySignClientTool tool = new AnySignClientTool(ip, port);
        ChannelMessage message = tool.pdfSign(ruleNumList, pdfBty);
        System.out.println(message.getStatusCode() + " " + message.getStatusInfo());
        if (message.getStatusCode().equals("200")) {
            ClientUtil.writeByteArrayToFile(new File(outputFilePath), message.getBody());
            System.out.println("\u8f93\u51fa\u6587\u4ef6\u8def\u5f84\uff1a" + outputFilePath);
        }
    }

    private static void pdfVerify(String[] args) throws IOException, Exception {
        String ip = args[0];
        int port = Integer.valueOf(args[1]);
        String inputFilePath = args[3];
        String outputFilePath = args[4];
        byte[] pdfBty = ClientUtil.readFileToByteArray(new File(inputFilePath));
        AnySignClientTool tool = new AnySignClientTool(ip, port);
        ChannelMessage message = tool.pdfVerify(pdfBty);
        System.out.println(message.getStatusCode() + " " + message.getStatusInfo());
        ClientUtil.writeByteArrayToFile(new File(outputFilePath), message.getStatusCode().getBytes());
    }

    private static void genClientSignDigest(String[] args) throws IOException, Exception {
        String ip = args[0];
        int port = Integer.valueOf(args[1]);
        String keyword = args[3];
        String moveType = args[4];
        String searchOrder = args[5];
        Integer moveSize = Integer.parseInt(args[6]);
        Integer heightMoveSize = Integer.parseInt(args[7]);
        float width = Float.parseFloat(args[8]);
        float height = Float.parseFloat(args[9]);
        String fileUniqueId = args[10];
        String pathname = args[11];
        String signCert = args[12];
        String sealImg = args[13];
        String outputFilePath = args[14];
        byte[] pdfBty = ClientUtil.readFileToByteArray(new File(pathname));
        ArrayList<ClientSignMessage> clientSignMessages = new ArrayList<ClientSignMessage>();
        ClientSignMessage clientSignMessage = new ClientSignMessage();
        clientSignMessage.setKeyword(keyword);
        clientSignMessage.setMoveType(moveType);
        clientSignMessage.setSearchOrder(searchOrder);
        clientSignMessage.setPdfBty(pdfBty);
        clientSignMessage.setFileUniqueId(fileUniqueId);
        clientSignMessage.setHeightMoveSize(heightMoveSize);
        clientSignMessage.setMoveSize(moveSize);
        clientSignMessages.add(clientSignMessage);
        AnySignClientTool tool = new AnySignClientTool(ip, port);
        ChannelMessage message = tool.genClientSignDigest(clientSignMessages, signCert, sealImg, width, height);
        System.out.println(message.getStatusCode() + " " + message.getStatusInfo());
        if (message.getStatusCode().equals("200")) {
            ClientUtil.writeByteArrayToFile(new File(outputFilePath), message.getBody());
        }
    }

    private static void genClientSign(String[] args) throws IOException, Exception {
        String ip = args[0];
        int port = Integer.valueOf(args[1]);
        String filepath = args[3];
        String outputFilePath = args[4];
        String json = new String(ClientUtil.readFileToByteArray(new File(filepath)));
        AnySignClientTool tool = new AnySignClientTool(ip, port);
        ChannelMessage message = tool.genClientSign(json);
        System.out.println(message.getStatusCode() + " " + message.getStatusInfo());
        if (message.getStatusCode().equals("200")) {
            List<ClientSignBean> signBeanList = message.getClientSignList();
            ClientUtil.writeByteArrayToFile(new File(outputFilePath), signBeanList.get(0).getPdfBty());
        }
    }

    private static void pdfSignByWord(String[] args) throws IOException, Exception {
        String ip = args[0];
        int port = Integer.valueOf(args[1]);
        String ruleNum = args[3];
        String filepath = args[4];
        String outputFilePath = args[5];
        AnySignClientTool tool = new AnySignClientTool(ip, port);
        ChannelMessage message = tool.pdfSignByWord(ruleNum, ClientUtil.readFileToByteArray(new File(filepath)));
        System.out.println(message.getStatusCode() + " " + message.getStatusInfo());
        if (message.getStatusCode().equals("200")) {
            ClientUtil.writeByteArrayToFile(new File(outputFilePath), message.getBody());
        }
    }
}

