/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.tools;

import cn.org.bjca.seal.esspdf.client.commons.InetAddressSingle;
import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import cn.org.bjca.seal.esspdf.client.message.ReqMessage;
import cn.org.bjca.seal.esspdf.client.tools.BaseClientTool;
import cn.org.bjca.seal.esspdf.client.utils.ClientUtil;

public class ESSOFDClientTool
extends BaseClientTool {
    public ESSOFDClientTool(String ip, int port) throws Exception {
        this.ip = ip;
        this.port = port;
    }

    public ESSOFDClientTool(String ... inetAddress) throws Exception {
        if (inetAddress.length > 1) {
            InetAddressSingle.getInstance(inetAddress);
            this.isConnections = true;
        } else {
            String[] dd = inetAddress[0].split(":");
            this.ip = dd[0];
            this.port = Integer.valueOf(dd[1]);
        }
    }

    public ChannelMessage ofdSign(String ruleNum, byte[] ofdBty) throws Exception {
        return this.ofdSign(ruleNum, null, null, ofdBty);
    }

    public ChannelMessage ofdSign(String ruleNum, String serverSealNum, String signPolicyNum, byte[] ofdBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || ofdBty == null || ofdBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(ofdBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        if (ClientUtil.isNotBlank(serverSealNum)) {
            reqMessage.setServerSealNum(serverSealNum);
        }
        if (ClientUtil.isNotBlank(signPolicyNum)) {
            reqMessage.setSignPolicyNum(signPolicyNum);
        }
        reqMessage.setType("101");
        return this.tcpTransport(reqMessage, ofdBty);
    }

    public ChannelMessage ofdVerify(byte[] ofdSignBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ofdSignBty == null || ofdSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(ofdSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("102");
        return this.tcpTransport(reqMessage, ofdSignBty);
    }

    public ChannelMessage genBarcodeAndOFD(String ruleNum, String contents, byte[] ofdBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || ClientUtil.isBlank(contents) || ofdBty == null || ofdBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkBarcodeSizeLimit(contents) || this.checkMaxFileSizeLimit(ofdBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("106");
        reqMessage.setContents(contents);
        return this.tcpTransport(reqMessage, ofdBty);
    }

    public ChannelMessage genBarcodeAndSign(String barcodeRuleNum, String signSealRuleNum, String contents, byte[] ofdBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(barcodeRuleNum) || ClientUtil.isBlank(signSealRuleNum) || ClientUtil.isBlank(contents) || ofdBty == null || ofdBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(barcodeRuleNum, signSealRuleNum) || this.checkBarcodeSizeLimit(contents) || this.checkMaxFileSizeLimit(ofdBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(barcodeRuleNum);
        reqMessage.setTemplateNum(signSealRuleNum);
        reqMessage.setType("110");
        reqMessage.setContents(contents);
        return this.tcpTransport(reqMessage, ofdBty);
    }
}

