/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.tools;

import cn.org.bjca.anysign.components.bean.message.MessageBodyReference;
import cn.org.bjca.anysign.components.bean.message.MessageBodyReferences;
import cn.org.bjca.seal.esspdf.client.channel.SocketClient;
import cn.org.bjca.seal.esspdf.client.commons.InetAddressSingle;
import cn.org.bjca.seal.esspdf.client.comparator.MessageBodyReferenceComparator;
import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import cn.org.bjca.seal.esspdf.client.message.ReqMessage;
import cn.org.bjca.seal.esspdf.client.pools.ConnectionThreadPool;
import cn.org.bjca.seal.esspdf.client.utils.ArrayUtil;
import cn.org.bjca.seal.esspdf.client.utils.ClientUtil;
import cn.org.bjca.seal.esspdf.client.utils.JsonMapper;
import cn.org.bjca.seal.esspdf.client.utils.SysConfigSingle;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BaseClientTool {
    SocketClient socketClient;
    int timeout = 500000;
    int respTimeout = 500000;
    String ip;
    int port;
    boolean isConnections = false;
    public static final int FILETYPE_PDF = 1;
    public static final int FILETYPE_ENCPACKAGE = 2;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRespTimeout(int respTimeout) {
        this.respTimeout = respTimeout;
    }

    void connect() throws Exception {
        block10: {
            if (this.isConnections) {
                while (true) {
                    Map<String, Integer> addressMap = InetAddressSingle.getInstance("").getAddressMap();
                    ArrayList<String> listKey = new ArrayList<String>();
                    for (String key : addressMap.keySet()) {
                        listKey.add(key);
                    }
                    int n = new Random().nextInt(listKey.size());
                    String ip2 = (String)listKey.get(n);
                    int port2 = addressMap.get(listKey.get(n));
                    try {
                        this.socketClient = new SocketClient(ip2, port2);
                        if (this.timeout > 0) {
                            this.socketClient.setTimeout(this.timeout);
                        }
                        if (this.respTimeout > 0) {
                            this.socketClient.setRespTimeout(this.respTimeout);
                        }
                        this.socketClient.connect();
                        break block10;
                    }
                    catch (Exception ex) {
                        if (listKey.size() == 1) {
                            throw new Exception(ex);
                        }
                        System.out.println("******Server connection error,ip is " + ip2 + ", port is " + port2);
                        addressMap.remove(ip2);
                        new ConnectionThreadPool(ip2, port2).start();
                        continue;
                    }
                    break;
                }
            }
            this.socketClient = new SocketClient(this.ip, this.port);
            if (this.timeout > 0) {
                this.socketClient.setTimeout(this.timeout);
            }
            if (this.respTimeout > 0) {
                this.socketClient.setRespTimeout(this.respTimeout);
            }
            this.socketClient.connect();
        }
    }

    ChannelMessage tcpTransport(ReqMessage reqMessage, byte[] paramBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        try {
            this.connect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message.setStatusCode("400");
            return message;
        }
        try {
            JsonMapper mapper = JsonMapper.nonEmptyMapper();
            String headJson = mapper.toJson(reqMessage);
            message = new ChannelMessage(paramBty);
            message.setHead(headJson.getBytes("UTF-8"));
            message = this.socketClient.sendMessages(message);
            if (message != null) {
                String headStr = new String(message.getHead(), "UTF-8");
                if (headStr.indexOf("{") != -1) {
                    message.setStatusCode("200");
                } else {
                    message.setStatusCode(new String(message.getHead()).trim());
                }
            }
        }
        catch (SocketTimeoutException ex) {
            ex.printStackTrace();
            message.setStatusCode("408");
        }
        return message;
    }

    ChannelMessage multiFileMessagedo(ChannelMessage channelMessage) throws UnsupportedEncodingException {
        String headStr;
        byte[] headBty = channelMessage.getHead();
        if (headBty != null && headBty.length > 0 && (headStr = new String(headBty, "UTF-8")).indexOf("{") != -1) {
            JsonMapper mapper = JsonMapper.nonDefaultMapper();
            MessageBodyReferences messageBodyReferences = mapper.fromJson(headStr, MessageBodyReferences.class);
            List messageBodyReferenceList = messageBodyReferences.getMessageBodyReferences();
            Collections.sort(messageBodyReferenceList, new MessageBodyReferenceComparator());
            int n = 0;
            byte[] pdfBty = null;
            for (MessageBodyReference messageBodyReference : messageBodyReferenceList) {
                pdfBty = ArrayUtil.subArray(channelMessage.getBody(), n, n + messageBodyReference.getFileSize());
                messageBodyReference.setFileBty(pdfBty);
                n += messageBodyReference.getFileSize();
            }
            channelMessage.setMessageBodyReferenceList(messageBodyReferenceList);
            channelMessage.setHead(channelMessage.getStatusCode().getBytes("UTF-8"));
            channelMessage.setBody("".getBytes());
        }
        return channelMessage;
    }

    @Deprecated
    boolean checkMaxFileSizeLimit(byte[] fileBty) throws Exception {
        BigDecimal megabyte;
        BigDecimal filesize;
        float currSize;
        SysConfigSingle single = SysConfigSingle.getInstance();
        String maxFileSize = single.getSysConfigInfo("maxFileSize");
        float fileSize = Float.parseFloat(maxFileSize);
        return fileSize < (currSize = (filesize = new BigDecimal(fileBty.length)).divide(megabyte = new BigDecimal(0x100000), 2, 0).floatValue());
    }

    boolean checkMaxFileSizeLimit(byte[] fileBty, int fileType) throws Exception {
        BigDecimal megabyte;
        BigDecimal filesize;
        float currSize;
        SysConfigSingle single = SysConfigSingle.getInstance();
        String maxFileSize = null;
        maxFileSize = 2 == fileType ? single.getSysConfigInfo("maxEncryptPackageSize") : single.getSysConfigInfo("maxAnyWriteFileSize");
        float fileSize = Float.parseFloat(maxFileSize);
        return fileSize < (currSize = (filesize = new BigDecimal(fileBty.length)).divide(megabyte = new BigDecimal(0x100000), 2, 0).floatValue());
    }

    boolean checkBarcodeSizeLimit(String contents) throws Exception {
        SysConfigSingle single = SysConfigSingle.getInstance();
        String barcodeMaxSize = single.getSysConfigInfo("barcodeMaxSize");
        int maxSize = Integer.parseInt(barcodeMaxSize);
        return maxSize < contents.length();
    }

    boolean checkCommonsStringSizeLimit(String ... params) throws Exception {
        SysConfigSingle single = SysConfigSingle.getInstance();
        String commonsMaxStringSize = single.getSysConfigInfo("commonsMaxStringSize");
        int maxSize = Integer.parseInt(commonsMaxStringSize);
        for (String param : params) {
            if (maxSize >= param.length()) continue;
            return true;
        }
        return false;
    }

    boolean checkCommonsNumSizeLimit(String ... params) throws Exception {
        SysConfigSingle single = SysConfigSingle.getInstance();
        String commonsMaxNumSize = single.getSysConfigInfo("commonsMaxNumSize");
        int maxSize = Integer.parseInt(commonsMaxNumSize);
        for (String param : params) {
            if (maxSize >= param.length()) continue;
            return true;
        }
        return false;
    }

    boolean checkAnyWriteBatchSizeLimit(int batchSize) {
        SysConfigSingle single = SysConfigSingle.getInstance();
        int maxAnyWriteBatchSize = Integer.parseInt(single.getSysConfigInfo("maxAnyWriteBatchSize"));
        return batchSize > maxAnyWriteBatchSize;
    }

    public byte[] gbkConvertToUTF8(byte[] gbkBty) throws Exception {
        String gbkStr = new String(gbkBty, "GBK");
        String codingTyp = this.getCodingType(gbkStr);
        if (ClientUtil.isNotBlank(codingTyp)) {
            gbkStr = gbkStr.replaceAll(codingTyp, "encoding=\"UTF-8\"");
        }
        int n = gbkStr.length();
        byte[] utfBytes = new byte[3 * n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            char m = gbkStr.charAt(i);
            if (m < '\u0080' && m >= '\u0000') {
                utfBytes[k++] = (byte)m;
                continue;
            }
            utfBytes[k++] = (byte)(0xE0 | m >> 12);
            utfBytes[k++] = (byte)(0x80 | m >> 6 & 0x3F);
            utfBytes[k++] = (byte)(0x80 | m & 0x3F);
        }
        if (k < utfBytes.length) {
            byte[] tmp = new byte[k];
            System.arraycopy(utfBytes, 0, tmp, 0, k);
            return tmp;
        }
        return utfBytes;
    }

    private String getCodingType(String gbkStr) {
        if (gbkStr.contains("encoding=\"gbk\"")) {
            return "encoding=\"gbk\"";
        }
        if (gbkStr.contains("encoding=\"GBK\"")) {
            return "encoding=\"GBK\"";
        }
        if (gbkStr.contains("encoding=\"gbk2312\"")) {
            return "encoding=\"gbk2312\"";
        }
        if (gbkStr.contains("encoding=\"GBK2312\"")) {
            return "encoding=\"GBK2312\"";
        }
        return null;
    }
}

