/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.tools;

import cn.org.bjca.anysign.components.bean.message.AnyWriteChallengeCodeReqMessage;
import cn.org.bjca.anysign.components.bean.message.ChallengeCodePDFInfo;
import cn.org.bjca.anysign.components.bean.message.ExternalAnyWriteInfo;
import cn.org.bjca.anysign.components.bean.message.ExternalEncryptPackageInfo;
import cn.org.bjca.common.model.GeneratePDFInfo;
import cn.org.bjca.seal.esspdf.client.commons.InetAddressSingle;
import cn.org.bjca.seal.esspdf.client.comparator.ServerDigestMessageComparator;
import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import cn.org.bjca.seal.esspdf.client.message.ClientSignBean;
import cn.org.bjca.seal.esspdf.client.message.ClientSignMessage;
import cn.org.bjca.seal.esspdf.client.message.KeywordBean;
import cn.org.bjca.seal.esspdf.client.message.RectangleBean;
import cn.org.bjca.seal.esspdf.client.message.ReqMessage;
import cn.org.bjca.seal.esspdf.client.message.ServerDigestMessage;
import cn.org.bjca.seal.esspdf.client.message.ServerDigestMessages;
import cn.org.bjca.seal.esspdf.client.message.SignSealImageBean;
import cn.org.bjca.seal.esspdf.client.tools.BaseClientTool;
import cn.org.bjca.seal.esspdf.client.utils.ArrayUtil;
import cn.org.bjca.seal.esspdf.client.utils.ClientUtil;
import cn.org.bjca.seal.esspdf.client.utils.JsonMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.util.encoders.Base64;
import sun.misc.BASE64Encoder;

public class AnySignClientTool
extends BaseClientTool {
    public AnySignClientTool(String ip, int port) throws Exception {
        this.ip = ip;
        this.port = port;
    }

    public AnySignClientTool(String ... inetAddress) throws Exception {
        if (inetAddress.length > 1) {
            InetAddressSingle.getInstance(inetAddress);
            this.isConnections = true;
        } else {
            String[] dd = inetAddress[0].split(":");
            this.ip = dd[0];
            this.port = Integer.valueOf(dd[1]);
        }
    }

    public ChannelMessage anyWriteEncPackage(byte[] encDataBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (encDataBty == null || encDataBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(encDataBty, 2)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("2000");
        message = this.tcpTransport(reqMessage, encDataBty);
        this.multiFileMessagedo(message);
        return message;
    }

    public ChannelMessage anyWritePDFSignFacade(List<ExternalAnyWriteInfo> externalAnyWriteInfoList) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (externalAnyWriteInfoList == null || externalAnyWriteInfoList.size() == 0) {
            message.setStatusCode("300");
            return message;
        }
        int size = externalAnyWriteInfoList.size();
        if (this.checkAnyWriteBatchSizeLimit(size)) {
            message.setStatusCode("701");
            return message;
        }
        ExternalAnyWriteInfo externalAnyWriteInfo = null;
        List generatePDFInfos = null;
        List encryptPackageInfos = null;
        GeneratePDFInfo generatePDFInfo = null;
        ExternalEncryptPackageInfo encryptPackageInfo = null;
        for (int i = 0; i < size; ++i) {
            int j;
            externalAnyWriteInfo = externalAnyWriteInfoList.get(i);
            encryptPackageInfos = externalAnyWriteInfo.getEncryptPackageInfoList();
            if (encryptPackageInfos != null) {
                int encryptPackageSize = encryptPackageInfos.size();
                for (j = 0; j < encryptPackageSize; ++j) {
                    encryptPackageInfo = (ExternalEncryptPackageInfo)encryptPackageInfos.get(j);
                    if (!this.checkMaxFileSizeLimit(encryptPackageInfo.getEncData(), 2)) continue;
                    message.setStatusCode("700");
                    return message;
                }
            }
            if ((generatePDFInfos = externalAnyWriteInfo.getGeneratePDFInfoList()) == null) continue;
            int packageSize = generatePDFInfos.size();
            if (this.checkAnyWriteBatchSizeLimit(packageSize)) {
                message.setStatusCode("701");
                return message;
            }
            for (j = 0; j < packageSize; ++j) {
                generatePDFInfo = (GeneratePDFInfo)generatePDFInfos.get(j);
                if (!this.checkMaxFileSizeLimit(generatePDFInfo.getDocContent(), 1)) continue;
                message.setStatusCode("700");
                return message;
            }
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("2001");
        reqMessage.setExternalAnyWriteInfoList(externalAnyWriteInfoList);
        message = this.tcpTransport(reqMessage, "".getBytes("UTF-8"));
        this.multiFileMessagedo(message);
        return message;
    }

    public ChannelMessage anyWriteDataSign(byte[] encPackage) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (encPackage == null || encPackage.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(encPackage, 2)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("4001");
        return this.tcpTransport(reqMessage, encPackage);
    }

    public ChannelMessage anyWriteDataVerify(byte[] signedPackage, String base64Plain) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (signedPackage == null || signedPackage.length == 0 || base64Plain == null || "".equals(base64Plain)) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(signedPackage, 2)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setContents(base64Plain);
        reqMessage.setType("4002");
        return this.tcpTransport(reqMessage, signedPackage);
    }

    public ChannelMessage anyWriteGenerateChallengeCode(AnyWriteChallengeCodeReqMessage message) throws Exception {
        ChannelMessage channelMessage = new ChannelMessage();
        if (message == null) {
            channelMessage.setStatusCode("300");
            return channelMessage;
        }
        List pdfInfos = message.getChallengeCodePDFInfos();
        if (pdfInfos != null) {
            int pdfInfoSize = pdfInfos.size();
            if (this.checkAnyWriteBatchSizeLimit(pdfInfoSize)) {
                channelMessage.setStatusCode("701");
                return channelMessage;
            }
            for (int i = 0; i < pdfInfoSize; ++i) {
                ChallengeCodePDFInfo pdfInfo = (ChallengeCodePDFInfo)pdfInfos.get(i);
                if (!this.checkMaxFileSizeLimit(pdfInfo.getGeneratePDFInfo().getDocContent(), 1)) continue;
                channelMessage.setStatusCode("700");
                return channelMessage;
            }
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setAnyWriteChallengeCodeReqMessage(message);
        reqMessage.setType("6001");
        return this.tcpTransport(reqMessage, " ".getBytes());
    }

    public ChannelMessage anyWriteChallengeCodeSign(AnyWriteChallengeCodeReqMessage message) throws Exception {
        ChannelMessage channelMessage = new ChannelMessage();
        if (message == null) {
            channelMessage.setStatusCode("300");
            return channelMessage;
        }
        List pdfInfos = message.getChallengeCodePDFInfos();
        if (pdfInfos != null) {
            int pdfInfoSize = pdfInfos.size();
            if (this.checkAnyWriteBatchSizeLimit(pdfInfoSize)) {
                channelMessage.setStatusCode("701");
                return channelMessage;
            }
            for (int i = 0; i < pdfInfoSize; ++i) {
                ChallengeCodePDFInfo pdfInfo = (ChallengeCodePDFInfo)pdfInfos.get(i);
                if (!this.checkMaxFileSizeLimit(pdfInfo.getGeneratePDFInfo().getDocContent(), 1)) continue;
                channelMessage.setStatusCode("700");
                return channelMessage;
            }
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setAnyWriteChallengeCodeReqMessage(message);
        reqMessage.setType("6002");
        channelMessage = this.tcpTransport(reqMessage, " ".getBytes());
        this.multiFileMessagedo(channelMessage);
        return channelMessage;
    }

    public ChannelMessage pdfSign(String ruleNum, byte[] pdfBty) throws Exception {
        return this.pdfSign(ruleNum, null, null, pdfBty);
    }

    public ChannelMessage pdfSignImage(String ruleNum, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("43");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSign(String ruleNum, String serverSealNum, String signPolicyNum, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        if (ClientUtil.isNotBlank(serverSealNum)) {
            reqMessage.setServerSealNum(serverSealNum);
        }
        if (ClientUtil.isNotBlank(signPolicyNum)) {
            reqMessage.setSignPolicyNum(signPolicyNum);
        }
        reqMessage.setType("1");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSign(List<String> ruleNumList, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ruleNumList == null || ruleNumList.size() == 0 || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNumList.get(0));
        ruleNumList.remove(0);
        reqMessage.setRuleNumList(ruleNumList);
        reqMessage.setType("1");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByParam(byte[] pdfBty, String ruleNum, List<RectangleBean> beans) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (beans == null || beans.size() == 0 || ClientUtil.isBlank(ruleNum) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("34");
        RectangleBean recbean = beans.get(0);
        reqMessage.setContents("" + recbean.getPageNo() + "##" + recbean.getLeft() + "##" + recbean.getTop() + "##" + recbean.getRight() + "##" + recbean.getBottom());
        beans.remove(0);
        String contents = "";
        for (RectangleBean bean : beans) {
            contents = contents + "" + bean.getPageNo() + "##" + bean.getLeft() + "##" + bean.getTop() + "##" + bean.getRight() + "##" + bean.getBottom() + ";";
        }
        if (contents.endsWith(";")) {
            contents = contents.substring(0, contents.length() - 1);
        }
        reqMessage.setOrgCode(contents);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByWord(String ruleNum, byte[] wordBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || wordBty == null || wordBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(wordBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("12");
        return this.tcpTransport(reqMessage, wordBty);
    }

    public ChannelMessage pdfSignByImages(List<String> ruleNumList, List<ClientSignMessage> clientSignMessages) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ruleNumList == null || ruleNumList.size() == 0 || clientSignMessages == null || clientSignMessages.size() == 0) {
            message.setStatusCode("300");
            return message;
        }
        byte[] allPdfBty = new byte[]{};
        int i = 1;
        for (ClientSignMessage clientSignMessage : clientSignMessages) {
            clientSignMessage.setNum(i++);
            clientSignMessage.setFileSize(clientSignMessage.getPdfBty().length);
            allPdfBty = ArrayUtil.mergeArray(allPdfBty, clientSignMessage.getPdfBty());
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNumList.get(0));
        ruleNumList.remove(0);
        reqMessage.setRuleNumList(ruleNumList);
        reqMessage.setClientSignMessages(clientSignMessages);
        reqMessage.setType("20");
        return this.tcpTransport(reqMessage, allPdfBty);
    }

    public ChannelMessage pdfMultiPageSign(String ruleNum, byte[] pdfBty, String watermarkName) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setContents(watermarkName);
        reqMessage.setType("23");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfMultiPageSignByImages(String ruleNum, List<ClientSignMessage> clientSignMessages, String watermarkName) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || clientSignMessages == null || clientSignMessages.size() == 0) {
            message.setStatusCode("300");
            return message;
        }
        byte[] allImgBty = new byte[]{};
        int i = 1;
        for (ClientSignMessage clientSignMessage : clientSignMessages) {
            clientSignMessage.setNum(i++);
            clientSignMessage.setFileSize(clientSignMessage.getPdfBty().length);
            allImgBty = ArrayUtil.mergeArray(allImgBty, clientSignMessage.getPdfBty());
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setClientSignMessages(clientSignMessages);
        reqMessage.setContents(watermarkName);
        reqMessage.setType("21");
        return this.tcpTransport(reqMessage, allImgBty);
    }

    public ChannelMessage pdfSpeedSign(List<String> ruleNumList, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ruleNumList == null || ruleNumList.size() == 0 || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNumList.get(0));
        ruleNumList.remove(0);
        reqMessage.setRuleNumList(ruleNumList);
        reqMessage.setType("5");
        ChannelMessage mes = this.tcpTransport(reqMessage, pdfBty);
        if ("200".equals(mes.getStatusCode())) {
            int i = pdfBty.length;
            byte[] signDataBty = mes.getBody();
            int j = signDataBty.length;
            byte[] all = new byte[i + j];
            System.arraycopy(pdfBty, 0, all, 0, i);
            System.arraycopy(signDataBty, 0, all, i, j);
            mes.setBodyLength(all.length);
            mes.setBody(all);
        }
        return mes;
    }

    public ChannelMessage pdfVerify(String orgCode, byte[] pdfSignBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(orgCode) || pdfSignBty == null || pdfSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(orgCode) || this.checkMaxFileSizeLimit(pdfSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setOrgCode(orgCode);
        reqMessage.setType("2");
        return this.tcpTransport(reqMessage, pdfSignBty);
    }

    public ChannelMessage pdfVerify(byte[] pdfSignBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfSignBty == null || pdfSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("2");
        return this.tcpTransport(reqMessage, pdfSignBty);
    }

    public ChannelMessage pdfVerifyWithAnysign(byte[] pdfSignBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfSignBty == null || pdfSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("41");
        return this.tcpTransport(reqMessage, pdfSignBty);
    }

    public ChannelMessage pdfFormVerify(byte[] pdfSignBty, String type) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfSignBty == null || pdfSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType(type);
        return this.tcpTransport(reqMessage, pdfSignBty);
    }

    public ChannelMessage genPDFDocument(String templateNum, byte[] dataBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(templateNum) || dataBty == null || dataBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(templateNum) || this.checkMaxFileSizeLimit(dataBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setTemplateNum(templateNum);
        reqMessage.setType("3");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage genPDFDocumentAndSign(String templateNum, String ruleNum, byte[] dataBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(templateNum) || dataBty == null || dataBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(templateNum, ruleNum) || this.checkMaxFileSizeLimit(dataBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setTemplateNum(templateNum);
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("4");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage genPDFDocumentAndSign(String templateNum, List<String> ruleNumList, byte[] dataBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(templateNum) || dataBty == null || dataBty.length == 0 || ruleNumList == null || ruleNumList.size() == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(templateNum) || this.checkMaxFileSizeLimit(dataBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setTemplateNum(templateNum);
        reqMessage.setRuleNum(ruleNumList.get(0));
        ruleNumList.remove(0);
        reqMessage.setRuleNumList(ruleNumList);
        reqMessage.setType("4");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage genPDFInvoiceAndSign(String templateNum, String ruleNum, String fileName, byte[] dataBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(templateNum) || ClientUtil.isBlank(ruleNum) || ClientUtil.isBlank(fileName) || dataBty == null || dataBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(templateNum, ruleNum, fileName) || this.checkMaxFileSizeLimit(dataBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setTemplateNum(templateNum);
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setOrgCode(fileName);
        reqMessage.setType("13");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage genBarcode(String ruleNum, String contents, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || ClientUtil.isBlank(contents) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkBarcodeSizeLimit(contents) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("6");
        reqMessage.setContents(contents);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage genBarcodeAndSign(String barcodeRuleNum, String signSealRuleNum, String contents, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(barcodeRuleNum) || ClientUtil.isBlank(signSealRuleNum) || ClientUtil.isBlank(contents) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(barcodeRuleNum, signSealRuleNum) || this.checkBarcodeSizeLimit(contents) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(barcodeRuleNum);
        reqMessage.setTemplateNum(signSealRuleNum);
        reqMessage.setType("10");
        reqMessage.setContents(contents);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage genBarcode(String ruleNum, byte[] xmlBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || xmlBty == null || xmlBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(xmlBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("7");
        return this.tcpTransport(reqMessage, xmlBty);
    }

    public ChannelMessage genBarcodeImage(String ruleNum, byte[] contentBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || contentBty == null || contentBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(contentBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("8");
        return this.tcpTransport(reqMessage, contentBty);
    }

    public ChannelMessage genBarcodeAndSign(String barcodeRuleNum, String signSealRuleNum, byte[] xmlBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(barcodeRuleNum) || ClientUtil.isBlank(signSealRuleNum) || xmlBty == null || xmlBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(barcodeRuleNum, signSealRuleNum) || this.checkMaxFileSizeLimit(xmlBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(barcodeRuleNum);
        reqMessage.setTemplateNum(signSealRuleNum);
        reqMessage.setType("9");
        return this.tcpTransport(reqMessage, xmlBty);
    }

    public ChannelMessage exportXMLData(byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("11");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage exportXFAXMLData(byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("42");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage genClientSignDigest(List<ClientSignMessage> clientSignMessages, String signCert, String sealImg, float sealWidth, float sealHeight) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (clientSignMessages == null || clientSignMessages.size() == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsStringSizeLimit(signCert, sealImg)) {
            message.setStatusCode("700");
            return message;
        }
        byte[] allPdfBty = new byte[]{};
        int i = 1;
        for (ClientSignMessage clientSignMessage : clientSignMessages) {
            clientSignMessage.setNum(i++);
            clientSignMessage.setFileSize(clientSignMessage.getPdfBty().length);
            allPdfBty = ArrayUtil.mergeArray(allPdfBty, clientSignMessage.getPdfBty());
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setSealImg(sealImg);
        reqMessage.setSignCert(signCert);
        reqMessage.setSealWidth(sealWidth);
        reqMessage.setSealHeight(sealHeight);
        reqMessage.setClientSignMessages(clientSignMessages);
        reqMessage.setType("14");
        return this.tcpTransport(reqMessage, allPdfBty);
    }

    public ChannelMessage genClientSign(String clientSignJson) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(clientSignJson)) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsStringSizeLimit(clientSignJson)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("15");
        message = this.tcpTransport(reqMessage, clientSignJson.getBytes("UTF-8"));
        if (message.getHead().length > 10) {
            String signSealMessagesJson = new String(message.getHead(), "UTF-8");
            JsonMapper mapper = JsonMapper.nonDefaultMapper();
            ServerDigestMessages clientSignMessages = mapper.fromJson(signSealMessagesJson, ServerDigestMessages.class);
            List<ServerDigestMessage> clientSignList = clientSignMessages.getDigestMessages();
            Collections.sort(clientSignList, new ServerDigestMessageComparator());
            int n = 0;
            byte[] pdfBty = null;
            ArrayList<ClientSignBean> signList = new ArrayList<ClientSignBean>();
            ClientSignBean signObj = null;
            for (ServerDigestMessage messageObj : clientSignList) {
                signObj = new ClientSignBean();
                signObj.setSignUniqueId(messageObj.getFileUniqueId());
                pdfBty = ArrayUtil.subArray(message.getBody(), n, n + messageObj.getFileSize());
                signObj.setPdfBty(pdfBty);
                signList.add(signObj);
                n += messageObj.getFileSize();
            }
            message.setClientSignList(signList);
            message.setHead("200".getBytes());
            message.setStatusCode(new String(message.getHead()).trim());
            message.setBody("".getBytes());
        }
        return message;
    }

    public ChannelMessage genBarcodeAndSignByWord(String barcodeRuleNum, String signSealRuleNum, String contents, byte[] docBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(barcodeRuleNum) || ClientUtil.isBlank(signSealRuleNum) || ClientUtil.isBlank(contents) || docBty == null || docBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(barcodeRuleNum, signSealRuleNum) || this.checkBarcodeSizeLimit(contents) || this.checkMaxFileSizeLimit(docBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(barcodeRuleNum);
        reqMessage.setTemplateNum(signSealRuleNum);
        reqMessage.setType("16");
        reqMessage.setContents(contents);
        return this.tcpTransport(reqMessage, docBty);
    }

    public ChannelMessage genBarcodeAndSeal(String ruleNum, byte[] contentBty, String dataSign, String usercert) throws Exception {
        if (ClientUtil.isBlank(ruleNum) || contentBty == null || contentBty.length == 0) {
            ChannelMessage message = new ChannelMessage();
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("17");
        String contentStr = new BASE64Encoder().encode(contentBty);
        StringBuffer sb = new StringBuffer();
        sb.append(contentStr);
        if (ClientUtil.isNotBlank(dataSign) && ClientUtil.isNotBlank(usercert)) {
            sb.append("&&").append(dataSign).append("&&").append(usercert);
        }
        return this.tcpTransport(reqMessage, sb.toString().getBytes());
    }

    public ChannelMessage barcodeVerify(String content) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(content)) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkBarcodeSizeLimit(content)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("18");
        return this.tcpTransport(reqMessage, content.getBytes());
    }

    public ChannelMessage pdfToImages(byte[] pdfBty, String formatName) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || ClientUtil.isBlank(formatName)) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(formatName) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("19");
        reqMessage.setRuleNum(formatName);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage queryPdfInfo(byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("25");
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByParam(byte[] pdfBty, byte[] sealBty, float sealWidth, float sealHeight, String certSN, boolean isPrintSeal, RectangleBean bean) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || sealBty == null || sealBty.length == 0 || ClientUtil.isBlank(certSN) || bean == null) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(certSN);
        reqMessage.setSealWidth(sealWidth);
        reqMessage.setSealHeight(sealHeight);
        reqMessage.setType("28");
        reqMessage.setTemplateNum("" + isPrintSeal);
        reqMessage.setContents("" + bean.getPageNo() + "##" + bean.getLeft() + "##" + bean.getTop() + "##" + bean.getRight() + "##" + bean.getBottom());
        reqMessage.setSealImg(new String(new BASE64Encoder().encode(sealBty)));
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByParam(byte[] pdfBty, String ruleNum, RectangleBean bean) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || ClientUtil.isBlank(ruleNum) || bean == null) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("34");
        reqMessage.setContents("" + bean.getPageNo() + "##" + bean.getLeft() + "##" + bean.getTop() + "##" + bean.getRight() + "##" + bean.getBottom());
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByParam(byte[] pdfBty, String serverSealNum, String certSN, boolean isPrintSeal, RectangleBean bean) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || ClientUtil.isBlank(certSN) || ClientUtil.isBlank(serverSealNum) || bean == null) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(certSN);
        reqMessage.setServerSealNum(serverSealNum);
        reqMessage.setType("28");
        reqMessage.setTemplateNum("" + isPrintSeal);
        reqMessage.setContents("" + bean.getPageNo() + "##" + bean.getLeft() + "##" + bean.getTop() + "##" + bean.getRight() + "##" + bean.getBottom());
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage pdfSignByKeyword(byte[] pdfBty, byte[] sealBty, float sealWidth, float sealHeight, String certSN, boolean isPrintSeal, KeywordBean bean) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfBty == null || pdfBty.length == 0 || sealBty == null || ClientUtil.isBlank(certSN) || sealBty.length == 0 || bean == null) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(certSN);
        reqMessage.setSealWidth(sealWidth);
        reqMessage.setSealHeight(sealHeight);
        reqMessage.setType("31");
        reqMessage.setTemplateNum("" + isPrintSeal);
        reqMessage.setContents("" + bean.getKeyword() + "##" + bean.getSearchOrder() + "##" + bean.getMoveType() + "##" + bean.getHeightMoveSize() + "##" + bean.getMoveSize());
        reqMessage.setSealImg(new String(new BASE64Encoder().encode(sealBty)));
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage genSignField(String ruleNum, String contents, byte[] pdfBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || pdfBty == null || pdfBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(pdfBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("29");
        reqMessage.setContents(contents);
        return this.tcpTransport(reqMessage, pdfBty);
    }

    public ChannelMessage genSignFieldByXML(String ruleNum, byte[] dataBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || dataBty == null || dataBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkCommonsNumSizeLimit(ruleNum) || this.checkMaxFileSizeLimit(dataBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setType("30");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage clearSignature(byte[] pdfSignBty) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (pdfSignBty == null || pdfSignBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(pdfSignBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("32");
        return this.tcpTransport(reqMessage, pdfSignBty);
    }

    public ChannelMessage genPDFDocumentAndBarcodeAndSign(String ruleNum, byte[] dataBty, String content) throws Exception {
        ChannelMessage message = new ChannelMessage();
        if (ClientUtil.isBlank(ruleNum) || ClientUtil.isBlank(content) || dataBty == null || dataBty.length == 0) {
            message.setStatusCode("300");
            return message;
        }
        if (this.checkMaxFileSizeLimit(dataBty)) {
            message.setStatusCode("700");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setRuleNum(ruleNum);
        reqMessage.setTemplateNum(ruleNum);
        reqMessage.setContents(content);
        reqMessage.setType("33");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage applyOnceCert(byte[] encP10Data) throws Exception {
        if (encP10Data == null || encP10Data.length == 0) {
            ChannelMessage message = new ChannelMessage();
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("3201");
        return this.tcpTransport(reqMessage, encP10Data);
    }

    public ChannelMessage applyTimeStamp(byte[] timeStampReqInfo) throws Exception {
        if (timeStampReqInfo == null || timeStampReqInfo.length == 0) {
            ChannelMessage message = new ChannelMessage();
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setType("2101");
        return this.tcpTransport(reqMessage, timeStampReqInfo);
    }

    public ChannelMessage dataP1Sign(String policyNum, byte[] dataBty) throws Exception {
        if (policyNum == null || dataBty == null) {
            ChannelMessage message = new ChannelMessage();
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setSignPolicyNum(policyNum);
        reqMessage.setType("50");
        return this.tcpTransport(reqMessage, dataBty);
    }

    public ChannelMessage dataP1Verify(String policyNum, byte[] dataSignedBty, byte[] signData) throws Exception {
        if (policyNum == null || dataSignedBty == null) {
            ChannelMessage message = new ChannelMessage();
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setSignPolicyNum(policyNum);
        reqMessage.setContents(Base64.toBase64String((byte[])signData));
        reqMessage.setType("51");
        return this.tcpTransport(reqMessage, dataSignedBty);
    }

    public ChannelMessage generateSealImage(SignSealImageBean signSealImageBean) throws Exception {
        if (signSealImageBean == null) {
            ChannelMessage message = new ChannelMessage();
            message.setStatusCode("300");
            return message;
        }
        ReqMessage reqMessage = new ReqMessage();
        reqMessage.setSignSealImageBean(signSealImageBean);
        reqMessage.setType("52");
        return this.tcpTransport(reqMessage, " ".getBytes());
    }
}

