/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.message;

import cn.org.bjca.anysign.components.bean.message.MessageBodyReference;
import cn.org.bjca.seal.esspdf.client.message.ClientSignBean;
import cn.org.bjca.seal.esspdf.client.utils.ChannelUtil;
import cn.org.bjca.seal.esspdf.client.utils.ErrorCodeSingle;
import java.util.Arrays;
import java.util.List;

public class ChannelMessage {
    private byte[] head;
    private int bodyLength;
    private byte[] body;
    private String statusCode;
    private List<ClientSignBean> clientSignList;
    private List<MessageBodyReference> messageBodyReferenceList;

    public ChannelMessage() {
    }

    public ChannelMessage(byte[] body) {
        this.bodyLength = body.length;
        this.body = body;
    }

    public int getBodyLength() {
        if (this.body != null) {
            return this.body.length;
        }
        return this.bodyLength;
    }

    public void setBodyLength(int bodyLength) {
        this.bodyLength = bodyLength;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
        this.bodyLength = body.length;
    }

    public byte[] getHead() {
        return this.head;
    }

    public void setHead(byte[] head) {
        this.head = ChannelUtil.byteToByte(head);
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusInfo() {
        return ErrorCodeSingle.getInstance().getErrorCodeInfo(this.statusCode);
    }

    public List<ClientSignBean> getClientSignList() {
        return this.clientSignList;
    }

    public void setClientSignList(List<ClientSignBean> clientSignList) {
        this.clientSignList = clientSignList;
    }

    public List<MessageBodyReference> getMessageBodyReferenceList() {
        return this.messageBodyReferenceList;
    }

    public void setMessageBodyReferenceList(List<MessageBodyReference> messageBodyReferenceList) {
        this.messageBodyReferenceList = messageBodyReferenceList;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelMessage other = (ChannelMessage)obj;
        if (!(this.head == other.head || this.head != null && Arrays.equals(this.head, other.head))) {
            return false;
        }
        if (this.bodyLength != other.bodyLength) {
            return false;
        }
        return this.body == other.body || this.body != null && Arrays.equals(this.body, other.body);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.head != null ? Arrays.hashCode(this.head) : 0);
        hash = 97 * hash + this.bodyLength;
        hash = 97 * hash + (this.body != null ? Arrays.hashCode(this.body) : 0);
        return hash;
    }
}

