/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.channel;

import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import cn.org.bjca.seal.esspdf.client.utils.ChannelUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketClient {
    private Socket socket = new Socket();
    private int timeout = 50000;
    private int respTimeout = 50000;
    private String ip;
    private int port;

    public SocketClient(String ip, int port) throws Exception {
        this.ip = ip;
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRespTimeout(int respTimeout) {
        this.respTimeout = respTimeout;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void connect() throws Exception {
        this.socket.connect(new InetSocketAddress(this.ip, this.port), this.timeout);
        this.socket.setSoTimeout(this.respTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelMessage sendMessages(ChannelMessage message) throws Exception {
        OutputStream outputStream = null;
        InputStream is = null;
        ChannelMessage messageObj = new ChannelMessage();
        try {
            int len;
            int offset;
            outputStream = this.socket.getOutputStream();
            byte[] headLengthBty = ChannelUtil.intToByte(message.getHead().length);
            byte[] headBty = ChannelUtil.byteToByte(message.getHead());
            byte[] bodyLengthBty = ChannelUtil.intToByte(message.getBodyLength());
            byte[] bodyBty = message.getBody();
            byte[] allBty = new byte[headLengthBty.length + headBty.length + bodyLengthBty.length + bodyBty.length];
            System.arraycopy(headLengthBty, 0, allBty, 0, headLengthBty.length);
            System.arraycopy(headBty, 0, allBty, headLengthBty.length, headBty.length);
            System.arraycopy(bodyLengthBty, 0, allBty, headLengthBty.length + headBty.length, bodyLengthBty.length);
            System.arraycopy(bodyBty, 0, allBty, headLengthBty.length + headBty.length + bodyLengthBty.length, bodyBty.length);
            outputStream.write(allBty);
            outputStream.flush();
            is = this.socket.getInputStream();
            byte[] bb = null;
            int n = 0;
            int headLength = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == 0) {
                    bb = new byte[4];
                    is.read(bb, 0, 4);
                    headLength = n = ChannelUtil.byteToInt(bb);
                    continue;
                }
                if (i == 1) {
                    bb = new byte[headLength];
                    offset = 0;
                    while ((len = is.read(bb, offset, n - offset)) + offset != n) {
                        offset = len + offset;
                    }
                    messageObj.setHead(bb);
                    continue;
                }
                if (i != 2) continue;
                bb = new byte[4];
                is.read(bb, 0, 4);
                n = ChannelUtil.byteToInt(bb);
                messageObj.setBodyLength(n);
            }
            if (n > 0) {
                byte[] bty = new byte[n];
                offset = 0;
                while ((len = is.read(bty, offset, n - offset)) + offset != n) {
                    offset = len + offset;
                }
                messageObj.setBody(bty);
            } else {
                messageObj = null;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        return messageObj;
    }
}

