/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.seal.esspdf.client.channel;

import cn.org.bjca.seal.esspdf.client.message.ChannelMessage;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;

public class NIOSocketChannelClient {
    private final String ip;
    private final int port;
    private int timeout = 3000;
    private static final int HEADER_DEFAULT_SIZE = 1024;
    private static final int BODY_DEFAULT_SIZE = 0x100000;
    private final ByteBuffer headerLenPreAlloc = ByteBuffer.allocateDirect(4);
    private final ByteBuffer headerPreAlloc = ByteBuffer.allocateDirect(1024);
    private final ByteBuffer bodyLenPreAlloc = ByteBuffer.allocateDirect(4);
    private final ByteBuffer bodyPreAlloc = ByteBuffer.allocateDirect(0x100000);

    public NIOSocketChannelClient(String ip, int port) {
        this(ip, port, 3000);
    }

    public NIOSocketChannelClient(String ip, int port, int timeout) {
        this.ip = ip;
        this.port = port;
        this.timeout = timeout;
    }

    public ChannelMessage sendMessages(ChannelMessage message) throws Exception {
        Selector selector = null;
        try {
            selector = Selector.open();
            SocketChannel sc = SocketChannel.open(new InetSocketAddress(this.ip, this.port));
            sc.configureBlocking(false);
            if (sc.finishConnect()) {
                sc.register(selector, 1);
                this.handleWrite(message, sc);
            } else {
                sc.register(selector, 8);
            }
            block4: while (true) {
                int select;
                if ((select = selector.select(this.timeout)) == 0) {
                    throw new TimeoutException("connected timeout");
                }
                Iterator<SelectionKey> i$ = selector.selectedKeys().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block4;
                    SelectionKey key = i$.next();
                    if (key.isConnectable()) {
                        this.handleConnected(message, key, selector);
                        continue;
                    }
                    if (!key.isReadable()) continue;
                    ChannelMessage channelMessage = this.handleRead(key);
                    return channelMessage;
                }
                break;
            }
        }
        finally {
            if (selector != null) {
                selector.close();
            }
        }
    }

    private ChannelMessage handleRead(SelectionKey key) throws IOException {
        this.headerLenPreAlloc.clear();
        this.bodyLenPreAlloc.clear();
        SocketChannel sc = (SocketChannel)key.channel();
        int readCount = sc.read(this.headerLenPreAlloc);
        if (readCount < 4) {
            throw new IOException("read server data error");
        }
        this.headerLenPreAlloc.flip();
        int headerLength = this.headerLenPreAlloc.getInt();
        ByteBuffer headerBf = null;
        if (headerLength <= this.headerPreAlloc.capacity()) {
            this.headerPreAlloc.clear();
            this.headerPreAlloc.limit(headerLength);
            headerBf = this.headerPreAlloc;
        } else {
            headerBf = ByteBuffer.allocateDirect(headerLength);
        }
        readCount = sc.read(headerBf);
        if (readCount < headerLength) {
            throw new IOException("read server data error");
        }
        headerBf.flip();
        readCount = sc.read(this.bodyLenPreAlloc);
        if (readCount < 4) {
            throw new IOException("read server data error");
        }
        this.bodyLenPreAlloc.flip();
        int bodyLength = this.bodyLenPreAlloc.getInt();
        ByteBuffer bodyBf = null;
        if (bodyLength <= this.bodyPreAlloc.capacity()) {
            this.bodyPreAlloc.clear();
            this.bodyPreAlloc.limit(bodyLength);
            bodyBf = this.bodyPreAlloc;
        } else {
            bodyBf = ByteBuffer.allocateDirect(bodyLength);
        }
        readCount = sc.read(bodyBf);
        if (readCount < bodyLength) {
            throw new IllegalStateException("server data is not full.");
        }
        bodyBf.flip();
        ChannelMessage message = new ChannelMessage();
        byte[] header = new byte[headerLength];
        headerBf.get(header);
        message.setHead(header);
        byte[] body = new byte[bodyLength];
        bodyBf.get(body);
        message.setBody(body);
        return message;
    }

    private void handleConnected(ChannelMessage message, SelectionKey key, Selector selector) throws IOException {
        SocketChannel sc = (SocketChannel)key.channel();
        if (!sc.finishConnect()) {
            throw new IOException("Connected Error..");
        }
        this.handleWrite(message, sc);
        sc.register(selector, 1);
    }

    private void handleWrite(ChannelMessage message, SocketChannel sc) throws IOException {
        ByteBuffer headerBf = null;
        ByteBuffer bodyBf = null;
        if (message.getHead().length <= this.headerPreAlloc.capacity()) {
            this.headerPreAlloc.limit(message.getHead().length);
            headerBf = this.headerPreAlloc;
        } else {
            headerBf = ByteBuffer.allocateDirect(message.getHead().length);
        }
        if (message.getBodyLength() <= this.bodyPreAlloc.capacity()) {
            this.bodyPreAlloc.limit(message.getBodyLength());
            bodyBf = this.bodyPreAlloc;
        } else {
            bodyBf = ByteBuffer.allocateDirect(message.getBodyLength());
        }
        this.headerLenPreAlloc.putInt(message.getHead().length).flip();
        headerBf.put(message.getHead()).flip();
        this.bodyLenPreAlloc.putInt(message.getBodyLength()).flip();
        bodyBf.put(message.getBody()).flip();
        ByteBuffer[] byteBuffers = new ByteBuffer[]{this.headerLenPreAlloc, headerBf, this.bodyLenPreAlloc, bodyBf};
        sc.write(byteBuffers);
    }
}

