/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.stringutil;

import cn.com.chinalife.wings.util.stringutil.WordCheckerSwitch;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WingsStringUtil {
    public static final String SEARCH_SEQ = "*";
    public static final String STRING_CHARACTER = "\u5305\u542b\u7279\u6b8a\u5b57\u7b26*";
    public static final String PARAM_COULD_NOT_BE_EMPTY = "param could not be empty!";

    private WingsStringUtil() {
    }

    public static List<String> getSubStringBetweenAAndB(String input, String a, String b, boolean trim) throws IllegalArgumentException {
        WingsStringUtil.paramValidator(input, a, b);
        ArrayList<String> result = new ArrayList<String>();
        char[] chars = input.toCharArray();
        WordCheckerSwitch wordCheckerSwitch = new WordCheckerSwitch(a, b);
        StringBuilder sub = new StringBuilder();
        block8: for (int i = 0; i < chars.length; ++i) {
            String switchSays;
            switch (switchSays = wordCheckerSwitch.swallow(chars[i])) {
                case "go_on": {
                    sub.append(chars[i]);
                    continue block8;
                }
                case "end": {
                    String sub1 = sub.toString();
                    if (trim) {
                        sub1 = StringUtils.trim((String)sub1);
                    }
                    result.add(sub1);
                    sub.delete(0, sub.length());
                    continue block8;
                }
            }
        }
        return result;
    }

    public static String deleteSubStringBetweenAAndB(String input, String a, String b) throws IllegalArgumentException {
        boolean mustContainsAB;
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        boolean bl = mustContainsAB = input.contains(a) && input.contains(b);
        if (!mustContainsAB) {
            return input;
        }
        WingsStringUtil.paramValidator(input, a, b);
        char[] chars = input.toCharArray();
        WordCheckerSwitch wordCheckerSwitch = new WordCheckerSwitch(a, b);
        StringBuilder result = new StringBuilder();
        boolean start = false;
        block12: for (int i = 0; i < chars.length; ++i) {
            String switchSays;
            switch (switchSays = wordCheckerSwitch.swallow(chars[i])) {
                case "wait": {
                    result.append(chars[i]);
                    continue block12;
                }
                case "start": {
                    start = true;
                    result.append(chars[i]);
                    result.delete(result.length() - a.length(), result.length());
                    continue block12;
                }
                case "go_on": {
                    if (start) continue block12;
                    result.append(chars[i]);
                    continue block12;
                }
                case "end": {
                    start = false;
                    continue block12;
                }
            }
        }
        return result.toString();
    }

    private static void paramValidator(String input, String a, String b) {
        boolean mustContainsAB;
        boolean bl = mustContainsAB = input.contains(a) && input.contains(b);
        if (!mustContainsAB) {
            throw new IllegalArgumentException("input must contains a and b!");
        }
        if (!WingsStringUtil.strAllNotEmpty(input, a, b)) {
            throw new IllegalArgumentException(PARAM_COULD_NOT_BE_EMPTY);
        }
    }

    public static String deleteFromSubStr(String input, String a) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        if (StringUtils.contains((CharSequence)a, (CharSequence)SEARCH_SEQ)) {
            throw new IllegalArgumentException(STRING_CHARACTER);
        }
        if (!WingsStringUtil.strAllNotEmpty(input, a)) {
            throw new IllegalArgumentException(PARAM_COULD_NOT_BE_EMPTY);
        }
        String[] result = input.split(a);
        if (result.length == 0) {
            return "";
        }
        return result[0];
    }

    private static boolean strAllNotEmpty(String ... a) {
        for (int i = 0; i < a.length; ++i) {
            if (!StringUtils.isEmpty((CharSequence)a[i])) continue;
            return false;
        }
        return true;
    }
}

