/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.ftp;

import cn.com.chinalife.wings.util.CheckUtil;
import cn.com.chinalife.wings.util.ftp.FtpClientProperties;
import cn.com.chinalife.wings.util.ftp.WingsFtpUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WingsZipUtil {
    private static final String FOLDER_IS_EMPTY_NOTHING_TO_DELETE = "Folder is Empty! Nothing To Delete!";
    public static final String FILE_RENAME_IS_FAILURE = "File rename is failure";
    private Logger logger = LoggerFactory.getLogger(WingsZipUtil.class);
    @Autowired
    private WingsFtpUtil wingsFtpUtil;
    @Autowired
    private FtpClientProperties baseProperties;
    public static final String JAVA_SUFFIX = "java";
    public static final String PROPERTIES_SUFFIX = "properties";
    public static final String XML_SUFFIX = "xml";
    private static final int BUFFER = 8192;
    private static final String STRING_SPOT = ".";
    private static final String STRING_SPOT_ZIP = ".zip";
    private static final String STRING_SUFFIX = "/";
    private static final String FILE_ZIP_PATH_COULD_NOT_BE_EMPTY = "File zip path could not be Empty!";
    private static final String FILE_ZIP_PATH_IS_NOT_CORRECT = "File zip path is not correct!";

    public boolean unZipFileToZipPath(String relativePath, String upZipFileName) {
        String localPath;
        String sourcePath;
        String zipPath;
        if (relativePath.contains(this.baseProperties.getAbsolutePath())) {
            relativePath = relativePath.substring(this.baseProperties.getAbsolutePath().length() + 1);
        }
        if (StringUtils.isEmpty((CharSequence)(zipPath = this.wingsFtpUtil.downloadFileToLocal(sourcePath = this.baseProperties.getAbsolutePath() + STRING_SUFFIX + relativePath, localPath = this.baseProperties.getLocalPath())))) {
            this.logger.warn("Download Zip File Failed!");
            return false;
        }
        String unZipPath = "";
        unZipPath = zipPath.contains(STRING_SUFFIX) ? zipPath.substring(0, zipPath.lastIndexOf(STRING_SUFFIX) + 1) : zipPath.substring(0, zipPath.lastIndexOf(File.separator) + 1);
        String localFilePath = this.unZip(zipPath, unZipPath, upZipFileName);
        String targetPath = "";
        targetPath = sourcePath.contains(STRING_SUFFIX) ? sourcePath.substring(0, sourcePath.lastIndexOf(STRING_SUFFIX)) : sourcePath.substring(0, sourcePath.lastIndexOf(File.separator));
        this.wingsFtpUtil.uploadEntireLocalFolder(localFilePath, targetPath, CheckUtil.JAVA_SUFFIX);
        String sourceZipPath = localFilePath + STRING_SPOT_ZIP;
        File tmpFile = new File(sourceZipPath);
        this.deleteZip(localFilePath, tmpFile);
        return true;
    }

    private void deleteZip(String absolute, File tmpFile) {
        tmpFile.delete();
        this.deleteTarget(absolute);
        File file = new File(absolute);
        file.delete();
    }

    private void deleteTarget(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        String[] list = file.list();
        if (list == null) {
            this.logger.warn(FOLDER_IS_EMPTY_NOTHING_TO_DELETE);
            return;
        }
        File temp = null;
        String path = null;
        for (String item : list) {
            path = filePath + File.separator + item;
            temp = new File(path);
            if (temp.isFile()) {
                temp.delete();
                continue;
            }
            if (!temp.isDirectory()) continue;
            this.deleteTarget(path);
            new File(path).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unZip(String zipPath, String unZipPath, String upZipFileName) {
        if (StringUtils.isEmpty((CharSequence)zipPath)) {
            throw new IllegalArgumentException(FILE_ZIP_PATH_COULD_NOT_BE_EMPTY);
        }
        if (unZipPath.endsWith(STRING_SUFFIX)) {
            unZipPath = StringUtils.removeEnd((String)unZipPath, (String)STRING_SUFFIX);
        }
        unZipPath = unZipPath + STRING_SUFFIX;
        File pathFile = new File(zipPath);
        if (!pathFile.exists()) {
            throw new IllegalArgumentException(FILE_ZIP_PATH_IS_NOT_CORRECT);
        }
        ZipFile zipFile = null;
        try {
            FileOutputStream out = null;
            zipFile = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zipFile.getInputStream(entry);
                try {
                    int len;
                    String outPath = unZipPath + zipEntryName;
                    File file = new File(outPath.substring(0, outPath.lastIndexOf(STRING_SUFFIX)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (new File(outPath).isDirectory()) continue;
                    out = new FileOutputStream(outPath);
                    byte[] buf = new byte[8192];
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    IOUtils.closeQuietly((Closeable)in);
                }
                catch (Exception e) {
                    this.logger.error("Current error file name :" + zipEntryName);
                    this.logger.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)in);
                    IOUtils.closeQuietly(out);
                    continue;
                }
                IOUtils.closeQuietly((Closeable)out);
            }
        }
        catch (IOException e) {
            try {
                this.logger.error("\u89e3\u538b\u7f29\u65b9\u6cd5\u65b9\u6cd5\u4e2d\u51fa\u73b0IO\u6d41\u5f02\u5e38", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)zipFile);
        }
        IOUtils.closeQuietly((Closeable)zipFile);
        String unZipName = "";
        unZipName = zipPath.contains(STRING_SUFFIX) ? unZipPath + zipPath.substring(zipPath.lastIndexOf(STRING_SUFFIX) + 1, zipPath.lastIndexOf(STRING_SPOT)) : unZipPath + zipPath.substring(zipPath.lastIndexOf(File.separator) + 1, zipPath.lastIndexOf(STRING_SPOT));
        if (StringUtils.isEmpty((CharSequence)upZipFileName)) {
            return unZipName;
        }
        File unZipFile = new File(unZipName);
        String renameUnZipName = unZipPath + upZipFileName;
        File renameUnZipFile = new File(renameUnZipName);
        boolean flag = unZipFile.renameTo(renameUnZipFile);
        if (!flag) {
            new IllegalArgumentException(FILE_RENAME_IS_FAILURE);
        }
        return renameUnZipName;
    }
}

