/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.ftp;

import cn.com.chinalife.wings.util.ftp.FtpClientFactory;
import cn.com.chinalife.wings.util.ftp.FtpClientPoolProperties;
import cn.com.chinalife.wings.util.ftp.FtpClientProperties;
import cn.com.chinalife.wings.util.stringutil.WingsStringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class WingsFtpUtil {
    private static final String STRING_SUFFIX = "/";
    private static final String STRING_NONE = "NONE";
    private static final String STRING_SPOT = ".";
    private static final String EMPTY_PARAM_MESSAGE = "The param '%s' is empty ! Please check the param and try again.";
    static final String CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL = "Can not borrow FtpClient From the pool!";
    private static final String FILE_NAME_COULD_NOT_BE_EMPTY = "File name could not be Empty!";
    private static final String FILE_PATH_COULD_NOT_BE_EMPTY = "File path could not be Empty!";
    private static final String FILE_SOURCE_PATH_COULD_NOT_BE_EMPTY = "File source path could not be Empty!";
    private static final String FILE_LOCAL_PATH_COULD_NOT_BE_EMPTY = "File local path could not be Empty!";
    private static final String FILE_SOURCE_PATH_IS_NOT_CORRECT = "File source path is not correct!";
    private static final String INPUT_STEAM_IS_EMPTY_BLACK_MAN_FACE = "InputSteam is Empty??? Black man ? face";
    private static final String CAN_NOT_CLOSE_THE_INPUT_STREAM_FROM_THE_FTP_CLIENT = "can not close the InputStream From the FtpClient!";
    private static final String FOLDER_CREATE_FAILED = "Folder create failed!";
    private static final String MULTIPART_FILE_COULD_NOT_BE_NULL = "MultipartFile could not be null!";
    private static final String SOURCE_PATH_MUST_BE_POINT_TO_A_FOLDER = "SourcePath must be point to a Folder!";
    public static final String TARGET = "target";
    public static final String FILEUPLOAD_SWITCH_IS_FALSE = "fileupload switch is false";
    public static final String FILEUPLOAD_SWITCH_IS_TRUE = "fileupload switch is true";
    private Logger logger = LoggerFactory.getLogger(WingsFtpUtil.class);
    private GenericObjectPool<FTPClient> pool;
    private FtpClientProperties baseProperties;
    private FtpClientPoolProperties poolProperties;
    private static final String COMMENT_STYLE_1 = "//";
    private File tempDir;

    GenericObjectPool<FTPClient> getPool() {
        return this.pool;
    }

    public WingsFtpUtil(FtpClientProperties config1, FtpClientPoolProperties config2) {
        this.baseProperties = config1;
        this.poolProperties = config2;
    }

    @PostConstruct
    public final void init() {
        boolean flag = this.baseProperties.isClientSwitch();
        if (!flag) {
            this.logger.info(FILEUPLOAD_SWITCH_IS_FALSE);
            return;
        }
        this.logger.info(FILEUPLOAD_SWITCH_IS_TRUE);
        GenericObjectPoolConfig<FTPClient> genericObjectPoolConfig = this.assemblePoolConfig();
        FtpClientFactory factory = new FtpClientFactory(this.baseProperties);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory, genericObjectPoolConfig);
        try {
            this.pool.preparePool();
            int idles = this.pool.getNumIdle();
            int active = this.pool.getNumActive();
            this.logger.info("FtpClient Connection Pool init success!Current idle num is " + idles + " ,active num is " + active + " !");
        }
        catch (Exception e) {
            this.logger.error("FtpClient Connection Pool init failed!Please Check Config and Restart The server!");
        }
    }

    private GenericObjectPoolConfig<FTPClient> assemblePoolConfig() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(this.poolProperties.getMaxIdle());
        genericObjectPoolConfig.setMinIdle(this.poolProperties.getMinIdle());
        genericObjectPoolConfig.setMaxTotal(this.poolProperties.getMaxTotal());
        genericObjectPoolConfig.setBlockWhenExhausted(true);
        genericObjectPoolConfig.setEvictorShutdownTimeoutMillis(this.poolProperties.getEvictorShutdownTimeoutMillis());
        genericObjectPoolConfig.setFairness(this.poolProperties.isFairness());
        genericObjectPoolConfig.setMaxWaitMillis(this.poolProperties.getMaxWaitMillis());
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis(this.poolProperties.getMinEvictableIdleTimeMillis());
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(this.poolProperties.getTimeBetweenEvictionRunsMillis());
        genericObjectPoolConfig.setTestOnBorrow(this.poolProperties.isTestOnBorrow());
        genericObjectPoolConfig.setTestOnCreate(this.poolProperties.isTestOnCreate());
        genericObjectPoolConfig.setTestOnReturn(this.poolProperties.isTestOnReturn());
        genericObjectPoolConfig.setTestWhileIdle(this.poolProperties.isTestWhileIdle());
        return genericObjectPoolConfig;
    }

    @PreDestroy
    public final void destroy() {
        if (this.pool != null) {
            this.pool.clear();
            this.pool.close();
            this.pool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readRemoteJavaFileToStringWithoutComment(String fileName) {
        FTPClient ftpClient = null;
        String resultStr = "";
        try {
            ftpClient = (FTPClient)this.pool.borrowObject();
            if (ftpClient == null) {
                throw new IllegalStateException(CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL);
            }
            InputStream in = ftpClient.retrieveFileStream(fileName);
            StringBuilder result = new StringBuilder();
            if (in == null) {
                throw new IllegalStateException("Can not Open InputStream From the Remote File!");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                String data;
                while ((data = br.readLine()) != null) {
                    if (!StringUtils.isNotEmpty((CharSequence)(data = WingsStringUtil.deleteFromSubStr(data, COMMENT_STYLE_1)))) continue;
                    result.append(data);
                }
                resultStr = result.toString();
            }
            catch (IOException e) {
                this.logger.error("Read File Failed!");
                this.logger.error(e.getMessage());
            }
            finally {
                try {
                    in.close();
                    ftpClient.completePendingCommand();
                }
                catch (IOException ioee) {
                    this.logger.error(CAN_NOT_CLOSE_THE_INPUT_STREAM_FROM_THE_FTP_CLIENT);
                    this.logger.error(ioee.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            this.logger.error(CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL);
        }
        finally {
            this.recycle(ftpClient);
        }
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readRemoteFileToString(String fileName) {
        FTPClient ftpClient = null;
        String resultStr = "";
        try {
            ftpClient = (FTPClient)this.pool.borrowObject();
            if (ftpClient == null) {
                throw new IllegalStateException(CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL);
            }
            InputStream in = ftpClient.retrieveFileStream(fileName);
            StringBuilder result = new StringBuilder();
            if (in == null) {
                throw new IllegalStateException("Can not Open InputStream From the Remote File!");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                String data;
                while ((data = br.readLine()) != null) {
                    result.append(data);
                }
                resultStr = result.toString();
            }
            catch (IOException e) {
                this.logger.error("Read File Failed!");
                this.logger.error(e.getMessage());
            }
            finally {
                try {
                    IOUtils.closeQuietly((Closeable)in);
                    ftpClient.completePendingCommand();
                }
                catch (IOException ioee) {
                    this.logger.error(CAN_NOT_CLOSE_THE_INPUT_STREAM_FROM_THE_FTP_CLIENT);
                    this.logger.error(ioee.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL);
        }
        finally {
            this.recycle(ftpClient);
        }
        return resultStr;
    }

    void recycle(FTPClient object) {
        if (this.pool == null && object != null) {
            try {
                object.logout();
                object.disconnect();
                object = null;
            }
            catch (IOException ioe) {
                this.logger.error(ioe.getMessage());
            }
        }
        if (this.pool != null) {
            try {
                if (object != null) {
                    object.changeWorkingDirectory(this.baseProperties.getAbsolutePath());
                }
            }
            catch (IOException e) {
                this.logger.info(e.getMessage(), (Throwable)e);
            }
            this.pool.returnObject((Object)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveLocalFileToRemote(String path, String remote, InputStream inputStream) {
        if (StringUtils.isEmpty((CharSequence)remote)) {
            throw new IllegalArgumentException(FILE_NAME_COULD_NOT_BE_EMPTY);
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(INPUT_STEAM_IS_EMPTY_BLACK_MAN_FACE);
        }
        if (!path.contains(this.baseProperties.getAbsolutePath())) {
            path = this.baseProperties.getAbsolutePath() + STRING_SUFFIX + path;
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = (FTPClient)this.pool.borrowObject();
            if (ftpClient == null) {
                throw new IllegalStateException(CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL);
            }
            boolean folderExist = this.makeAbsolutePath(path, ftpClient);
            this.logger.info("\u4e0a\u4f20\u7edd\u5bf9\u8def\u5f84\u4e3a:" + path + "\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a:" + remote);
            if (!folderExist) {
                throw new IllegalStateException(FOLDER_CREATE_FAILED);
            }
            boolean flagDirectory = ftpClient.changeWorkingDirectory(path);
            this.logger.info("\u662f\u5426\u5207\u6362\u5230\u5f53\u524d\u8def\u5f84" + flagDirectory);
            boolean bl = ftpClient.storeFile(remote, inputStream);
            return bl;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
            this.recycle(ftpClient);
        }
        this.logger.info("\u4e0a\u4f20\u6210\u529f\u4e0d\u5e94\u8be5\u6267\u884c\u8fd9\u6b65");
        return false;
    }

    private boolean makeAbsolutePath(String path, FTPClient ftpClient) {
        try {
            if (ftpClient.changeWorkingDirectory(path)) {
                return true;
            }
            if (path.endsWith(STRING_SUFFIX)) {
                path = StringUtils.removeEnd((String)path, (String)STRING_SUFFIX);
            }
            path = path.substring(1);
            String[] stringList = path.split(STRING_SUFFIX);
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < stringList.length; ++i) {
                String subPath = STRING_SUFFIX + stringList[i];
                str.append(subPath);
                String parentPath = str.toString();
                if (ftpClient.changeWorkingDirectory(parentPath)) continue;
                String changeWorkPath = parentPath.substring(0, parentPath.lastIndexOf(STRING_SUFFIX));
                ftpClient.changeWorkingDirectory(changeWorkPath);
                ftpClient.makeDirectory(stringList[i]);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadMultipartFile(String path, MultipartFile file) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException(FILE_PATH_COULD_NOT_BE_EMPTY);
        }
        if (file == null) {
            throw new IllegalArgumentException(MULTIPART_FILE_COULD_NOT_BE_NULL);
        }
        InputStream inputStream = null;
        String targetPath = "";
        try {
            inputStream = file.getInputStream();
            this.saveLocalFileToRemote(path, file.getOriginalFilename(), inputStream);
            targetPath = path + STRING_SUFFIX + file.getOriginalFilename();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        return targetPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFileToLocal(String sourcePath, String localPath) {
        if (StringUtils.isEmpty((CharSequence)sourcePath)) {
            throw new IllegalArgumentException(FILE_SOURCE_PATH_COULD_NOT_BE_EMPTY);
        }
        if (StringUtils.isEmpty((CharSequence)localPath)) {
            throw new IllegalArgumentException(FILE_LOCAL_PATH_COULD_NOT_BE_EMPTY);
        }
        File tmpFile = new File(localPath);
        if (!tmpFile.exists()) {
            tmpFile.mkdirs();
        }
        FTPClient ftpClient = null;
        InputStream inputStream = null;
        File tmpFileDir = null;
        try {
            ftpClient = (FTPClient)this.pool.borrowObject();
            String subPath = sourcePath.substring(sourcePath.lastIndexOf(STRING_SUFFIX) + 1);
            inputStream = ftpClient.retrieveFileStream(sourcePath);
            if (inputStream == null) {
                throw new IllegalArgumentException(FILE_SOURCE_PATH_IS_NOT_CORRECT);
            }
            tmpFileDir = new File(tmpFile.getPath() + File.separator + subPath);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFileDir);
            String string = localPath + STRING_SUFFIX + subPath;
            IOUtils.closeQuietly((Closeable)inputStream);
            this.recycle(ftpClient);
            return string;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            this.recycle(ftpClient);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadEntireLocalFolder(String sourcePath, String targetPath, List<String> list) {
        if (StringUtils.isEmpty((CharSequence)sourcePath)) {
            throw new IllegalArgumentException(FILE_SOURCE_PATH_COULD_NOT_BE_EMPTY);
        }
        File folder = new File(sourcePath);
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException(SOURCE_PATH_MUST_BE_POINT_TO_A_FOLDER);
        }
        if (!targetPath.contains(this.baseProperties.getAbsolutePath())) {
            targetPath = this.baseProperties.getAbsolutePath() + STRING_SUFFIX + targetPath;
        }
        if (targetPath.endsWith(STRING_SUFFIX)) {
            targetPath = StringUtils.removeEnd((String)targetPath, (String)STRING_SUFFIX);
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = (FTPClient)this.pool.borrowObject();
            if (ftpClient == null) {
                throw new IllegalArgumentException(CAN_NOT_BORROW_FTP_CLIENT_FROM_THE_POOL);
            }
            this.upload(folder, targetPath, ftpClient, list);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.recycle(ftpClient);
        }
        return targetPath + STRING_SUFFIX + folder.getName();
    }

    private void upload(File folder, String targetPath, FTPClient ftpClient, List<String> list) {
        try {
            String sourceName = folder.getName();
            ftpClient.changeWorkingDirectory(targetPath);
            ftpClient.makeDirectory(sourceName);
            String path = targetPath + STRING_SUFFIX + sourceName;
            ftpClient.changeWorkingDirectory(path);
            String[] files = folder.list();
            if (files == null) {
                this.logger.warn("Local Folder is Empty! Nothing to upload!");
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                File file1 = new File(folder.getPath() + File.separator + files[i]);
                if (file1.isDirectory()) {
                    this.upload(file1, path, ftpClient, list);
                    continue;
                }
                String fileName = file1.getName();
                if (list == null) {
                    FileInputStream inputStream = new FileInputStream(file1);
                    if (path.contains(TARGET)) continue;
                    this.saveLocalFileToRemote(path, fileName, inputStream);
                    IOUtils.closeQuietly((Closeable)inputStream);
                    continue;
                }
                String suffixName = "";
                suffixName = fileName.contains(STRING_SPOT) ? fileName.substring(fileName.lastIndexOf(STRING_SPOT)) : STRING_NONE;
                if (!list.contains(suffixName) || path.contains(TARGET)) continue;
                FileInputStream inputStream = new FileInputStream(file1);
                this.saveLocalFileToRemote(path, fileName, inputStream);
                IOUtils.closeQuietly((Closeable)inputStream);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

