/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.ftp;

import cn.com.chinalife.wings.util.ftp.BaseWingsFtpCustomInvoker;
import cn.com.chinalife.wings.util.ftp.WingsFtpUtil;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WingsFtpFileIterator
extends BaseWingsFtpCustomInvoker {
    private Logger logger = LoggerFactory.getLogger(WingsFtpFileIterator.class);
    public static final String STRING_SUFFIX = "/";
    private FTPListParseEngine engine;

    WingsFtpFileIterator() {
    }

    public WingsFtpFileIterator(WingsFtpUtil ftpUtil) {
        super(ftpUtil);
    }

    @Override
    public void doInvoke(String directory) {
        try {
            boolean flag = this.client.changeWorkingDirectory(directory);
            if (!flag) {
                this.logger.info("\u5207\u6362\u5230\u5f53\u524d\u8def\u5f84\u5931\u8d25:" + directory);
            }
            this.engine = this.client.initiateListParsing(directory);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.traversal(this.engine, directory);
    }

    private void traversal(FTPListParseEngine engine, String directory) {
        while (engine.hasNext()) {
            FTPFile[] files = engine.getNext(25);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FTPListParseEngine newEngine = null;
                    String nextPath = "";
                    try {
                        nextPath = directory + STRING_SUFFIX + files[i].getName();
                        newEngine = this.client.initiateListParsing(nextPath);
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    if (newEngine == null) continue;
                    this.traversal(newEngine, nextPath);
                    continue;
                }
                this.finalInvoke(files[i], directory);
            }
        }
    }

    protected abstract void finalInvoke(FTPFile var1, String var2);
}

