/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.ftp;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wings.ftp.client.pool")
public class FtpClientPoolProperties {
    private int maxTotal = 8;
    private int maxIdle = 2;
    private int minIdle = 2;
    private boolean fairness = false;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = true;
    private long maxWaitMillis = 5000L;
    private long timeBetweenEvictionRunsMillis = 30000L;
    private int numTestsPerEvictionRun = 4;
    private long minEvictableIdleTimeMillis = 30000L;
    private long evictorShutdownTimeoutMillis = 10000L;

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public boolean isFairness() {
        return this.fairness;
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public long getEvictorShutdownTimeoutMillis() {
        return this.evictorShutdownTimeoutMillis;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setFairness(boolean fairness) {
        this.fairness = fairness;
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setEvictorShutdownTimeoutMillis(long evictorShutdownTimeoutMillis) {
        this.evictorShutdownTimeoutMillis = evictorShutdownTimeoutMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FtpClientPoolProperties)) {
            return false;
        }
        FtpClientPoolProperties other = (FtpClientPoolProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.isFairness() != other.isFairness()) {
            return false;
        }
        if (this.isTestOnCreate() != other.isTestOnCreate()) {
            return false;
        }
        if (this.isTestOnBorrow() != other.isTestOnBorrow()) {
            return false;
        }
        if (this.isTestOnReturn() != other.isTestOnReturn()) {
            return false;
        }
        if (this.isTestWhileIdle() != other.isTestWhileIdle()) {
            return false;
        }
        if (this.getMaxWaitMillis() != other.getMaxWaitMillis()) {
            return false;
        }
        if (this.getTimeBetweenEvictionRunsMillis() != other.getTimeBetweenEvictionRunsMillis()) {
            return false;
        }
        if (this.getNumTestsPerEvictionRun() != other.getNumTestsPerEvictionRun()) {
            return false;
        }
        if (this.getMinEvictableIdleTimeMillis() != other.getMinEvictableIdleTimeMillis()) {
            return false;
        }
        return this.getEvictorShutdownTimeoutMillis() == other.getEvictorShutdownTimeoutMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FtpClientPoolProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getMaxIdle();
        result = result * 59 + this.getMinIdle();
        result = result * 59 + (this.isFairness() ? 79 : 97);
        result = result * 59 + (this.isTestOnCreate() ? 79 : 97);
        result = result * 59 + (this.isTestOnBorrow() ? 79 : 97);
        result = result * 59 + (this.isTestOnReturn() ? 79 : 97);
        result = result * 59 + (this.isTestWhileIdle() ? 79 : 97);
        long $maxWaitMillis = this.getMaxWaitMillis();
        result = result * 59 + (int)($maxWaitMillis >>> 32 ^ $maxWaitMillis);
        long $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + (int)($timeBetweenEvictionRunsMillis >>> 32 ^ $timeBetweenEvictionRunsMillis);
        result = result * 59 + this.getNumTestsPerEvictionRun();
        long $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + (int)($minEvictableIdleTimeMillis >>> 32 ^ $minEvictableIdleTimeMillis);
        long $evictorShutdownTimeoutMillis = this.getEvictorShutdownTimeoutMillis();
        result = result * 59 + (int)($evictorShutdownTimeoutMillis >>> 32 ^ $evictorShutdownTimeoutMillis);
        return result;
    }

    public String toString() {
        return "FtpClientPoolProperties(maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", fairness=" + this.isFairness() + ", testOnCreate=" + this.isTestOnCreate() + ", testOnBorrow=" + this.isTestOnBorrow() + ", testOnReturn=" + this.isTestOnReturn() + ", testWhileIdle=" + this.isTestWhileIdle() + ", maxWaitMillis=" + this.getMaxWaitMillis() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", numTestsPerEvictionRun=" + this.getNumTestsPerEvictionRun() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", evictorShutdownTimeoutMillis=" + this.getEvictorShutdownTimeoutMillis() + ")";
    }
}

