/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.ftp;

import cn.com.chinalife.wings.util.ftp.FtpClientProperties;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClientFactory
extends BasePooledObjectFactory<FTPClient> {
    private Logger logger = LoggerFactory.getLogger(FtpClientFactory.class);
    private FtpClientProperties config;

    public FtpClientFactory(FtpClientProperties config) {
        this.config = config;
    }

    public FTPClient create() throws Exception {
        FTPClient ftpClient = new FTPClient();
        ftpClient.configure(new FTPClientConfig("UNIX"));
        ftpClient.setControlEncoding(this.config.getEncoding());
        ftpClient.setConnectTimeout(this.config.getConnectTimeout().intValue());
        try {
            ftpClient.connect(this.config.getHost(), this.config.getPort().intValue());
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftpClient.disconnect();
                this.logger.warn("FTPServer refused connection,replyCode:{}", (Object)replyCode);
                return null;
            }
            if (!ftpClient.login(this.config.getUsername(), this.config.getPassword())) {
                this.logger.warn("ftpClient login failed... username is {}; password: {}", (Object)this.config.getUsername(), (Object)this.config.getPassword());
            }
            ftpClient.setFileType(2);
            ftpClient.changeWorkingDirectory(this.config.getAbsolutePath());
            ftpClient.setBufferSize(this.config.getBufferSize().intValue());
            if (this.config.isPassiveMode()) {
                ftpClient.enterLocalPassiveMode();
            }
            ftpClient.setControlKeepAliveTimeout(20L);
            ftpClient.setControlKeepAliveReplyTimeout(3000);
            ftpClient.sendNoOp();
        }
        catch (IOException e) {
            this.logger.error("create ftp connection failed...", (Throwable)e);
        }
        return ftpClient;
    }

    public PooledObject<FTPClient> wrap(FTPClient ftpClient) {
        return new DefaultPooledObject((Object)ftpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(PooledObject<FTPClient> ftpPooled) {
        if (ftpPooled == null) {
            return;
        }
        FTPClient ftpClient = (FTPClient)ftpPooled.getObject();
        try {
            if (ftpClient.isConnected()) {
                ftpClient.logout();
            }
        }
        catch (IOException io) {
            this.logger.error("ftp client logout failed...{}", (Throwable)io);
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (IOException io) {
                this.logger.error("close ftp client failed...{}", (Throwable)io);
            }
        }
    }

    public boolean validateObject(PooledObject<FTPClient> ftpPooled) {
        try {
            FTPClient ftpClient = (FTPClient)ftpPooled.getObject();
            return ftpClient.sendNoOp();
        }
        catch (IOException e) {
            this.logger.error("Failed to validate client: {}", (Throwable)e);
            return false;
        }
    }

    public void activateObject(PooledObject<FTPClient> ftpPooled) {
        try {
            FTPClient ftpClient = (FTPClient)ftpPooled.getObject();
            ftpClient.sendNoOp();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            this.logger.error("Failed to active FtpClient");
        }
    }
}

