/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.ftp;

import cn.com.chinalife.wings.util.ftp.WingsFtpUtil;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWingsFtpCustomInvoker {
    FTPClient client;
    protected WingsFtpUtil wingsFtpUtil;
    protected Logger logger = LoggerFactory.getLogger(BaseWingsFtpCustomInvoker.class);

    BaseWingsFtpCustomInvoker() {
    }

    public BaseWingsFtpCustomInvoker(WingsFtpUtil ftpUtil) {
        this.wingsFtpUtil = ftpUtil;
        try {
            this.client = (FTPClient)ftpUtil.getPool().borrowObject();
            if (this.client == null) {
                throw new IllegalStateException("Can not borrow FtpClient From the pool!");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public final void invoke(String dictionary) {
        try {
            this.logger.info("\u626b\u63cf\u6587\u4ef6\u7684\u8def\u5f84\u4e3a:" + dictionary);
            this.doInvoke(dictionary);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.wingsFtpUtil.recycle(this.client);
        }
    }

    public abstract void doInvoke(String var1);
}

