/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import cn.com.chinalife.wings.util.LoggerUtil;
import java.io.File;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileUtil {
    private static Logger logger = LoggerFactory.getLogger(ZipFileUtil.class);
    int COMP_STORE = 0;
    int COMP_DEFLATE = 8;
    int COMP_AES_ENC = 99;
    int DEFLATE_LEVEL_FASTEST = 1;
    int DEFLATE_LEVEL_FAST = 3;
    int DEFLATE_LEVEL_NORMAL = 5;
    int DEFLATE_LEVEL_MAXIMUM = 7;
    int DEFLATE_LEVEL_ULTRA = 9;
    int ENC_NO_ENCRYPTION = -1;
    int ENC_METHOD_STANDARD = 0;
    int ENC_METHOD_AES = 99;
    int AES_STRENGTH_128 = 1;
    int AES_STRENGTH_192 = 2;
    int AES_STRENGTH_256 = 3;

    public static boolean addZipDefault(String targetPath, File file) {
        try {
            ZipFile zipFile = new ZipFile(targetPath);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(CompressionMethod.DEFLATE);
            zipFile.addFolder(file, parameters);
            return ZipFileUtil.checkFileExists(targetPath);
        }
        catch (ZipException e) {
            LoggerUtil.error(logger, "add zip file is failure: {0}", e.getMessage());
            return false;
        }
    }

    private static boolean checkFileExists(String targetPath) {
        File file1 = new File(targetPath);
        if (!file1.exists()) {
            LoggerUtil.info(logger, "add zip file is exists");
            return false;
        }
        LoggerUtil.info(logger, "add zip file is success,target path is : {0}", targetPath);
        return true;
    }

    public static boolean addZipEncrypt(String targetPath, File file, String password) {
        try {
            ZipFile zipFile = new ZipFile(targetPath);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(CompressionMethod.DEFLATE);
            parameters.setCompressionLevel(CompressionLevel.NORMAL);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            zipFile.setPassword(password.toCharArray());
            parameters.setEncryptFiles(true);
            zipFile.addFolder(file, parameters);
            return ZipFileUtil.checkFileExists(targetPath);
        }
        catch (ZipException e) {
            LoggerUtil.error(logger, "add zip file is failure: {0}", e.getMessage());
            return false;
        }
    }
}

