/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TracerUtil {
    private static String ipSixteen = "ffffffff";
    private static String ipInt = "255255255255";
    private static final String UNKNOWN = "unknown";
    private static final String REGEX = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b";
    private static final Pattern PATTERN = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    private static AtomicInteger count = new AtomicInteger(1000);

    private TracerUtil() {
    }

    private static String getTraceId(String ip, long timestamp, int nextId) {
        StringBuilder appender = new StringBuilder(25);
        appender.append(ip).append(timestamp).append(nextId);
        return appender.toString();
    }

    static String generate() {
        return TracerUtil.getTraceId(ipSixteen, System.currentTimeMillis(), TracerUtil.getNextId());
    }

    public static String generate(String ip) {
        if (ip != null && !ip.isEmpty() && TracerUtil.validate(ip)) {
            return TracerUtil.getTraceId(TracerUtil.getIpSixteen(ip), System.currentTimeMillis(), TracerUtil.getNextId());
        }
        return TracerUtil.generate();
    }

    public static String get() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return "none";
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String traceId = request.getHeader("traceId");
        String traceIdBackUp = String.valueOf(request.getAttribute("traceId"));
        return StringUtils.isBlank((CharSequence)traceId) ? traceIdBackUp : traceId;
    }

    static String generateIpv4Id() {
        return ipInt;
    }

    static String generateIpv4Id(String ip) {
        if (ip != null && !ip.isEmpty() && TracerUtil.validate(ip)) {
            return TracerUtil.getIpInt(ip);
        }
        return ipInt;
    }

    private static boolean validate(String ip) {
        try {
            return PATTERN.matcher(ip).matches();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static String getIpSixteen(String ip) {
        String[] ips = ip.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String column : ips) {
            String hex = Integer.toHexString(Integer.parseInt(column));
            if (hex.length() == 1) {
                sb.append('0').append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static String getIpInt(String ip) {
        return ip.replace(".", "");
    }

    private static String getInetAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int getNextId() {
        int next;
        int current;
        while (!count.compareAndSet(current, next = (current = count.get()) > 9000 ? 1000 : current + 1)) {
        }
        return next;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    static {
        try {
            String ipAddress = TracerUtil.getInetAddress();
            if (ipAddress != null) {
                ipSixteen = TracerUtil.getIpSixteen(ipAddress);
                ipInt = TracerUtil.getIpInt(ipAddress);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

