/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SesbUtil {
    private static final int MAX_SIX = 6;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static Random random = new Random();

    private SesbUtil() {
    }

    public static String tranNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String time = sdf.format(System.currentTimeMillis());
        StringBuilder transNo = new StringBuilder(time);
        for (int i = 0; i < 6; ++i) {
            transNo.append(random.nextInt(10));
        }
        return transNo.toString();
    }

    public static Map<String, String> newUaaHeaders(String oriSys, String route) {
        return SesbUtil.headersMap(oriSys, route);
    }

    public static Map<String, String> newSESBHeaders(String oriSys, String route) {
        return SesbUtil.headersMap(oriSys, route);
    }

    public static Map<String, String> newJsonHeaders() {
        HashMap headers = Maps.newHashMap();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return headers;
    }

    private static Map<String, String> headersMap(String oriSys, String route) {
        HashMap headers = Maps.newHashMap();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        headers.put("ESB-ORISYS", oriSys);
        headers.put("ESB-TRANNO", SesbUtil.tranNo());
        headers.put("ESB-SIGNATURE", "");
        headers.put("ESB-BRANCHNO", "000000");
        headers.put("ESB-ROUTE", route);
        return headers;
    }
}

