/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class QrCodeUtil {
    public static InputStream generateQRCodeInputStream(String text) {
        ByteArrayInputStream inputStream = null;
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, 400, 400);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write((RenderedImage)bufferedImage, "png", imOut);
            inputStream = new ByteArrayInputStream(bs.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputStream;
    }

    public static byte[] generateQRCodeByte(String text) {
        byte[] by = null;
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, 400, 400);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write((RenderedImage)bufferedImage, "png", imOut);
            by = bs.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return by;
    }

    public static void main(String[] args) throws IOException {
        int index;
        InputStream input = QrCodeUtil.generateQRCodeInputStream("http://www.baidu.com");
        String destination = "E://2.jpg";
        byte[] bytes = new byte[1024];
        FileOutputStream downloadFile = new FileOutputStream(destination);
        while ((index = input.read(bytes)) != -1) {
            downloadFile.write(bytes, 0, index);
            downloadFile.flush();
        }
        input.close();
        downloadFile.close();
    }
}

