/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import cn.com.chinalife.wings.util.TracerUtil;
import cn.com.chinalife.wings.util.enums.BaseEnum;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggerUtil {
    private static Logger monitorLogger = LoggerFactory.getLogger((String)"monitor");

    private LoggerUtil() {
    }

    public static void debug(Logger logger, String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        if (logger.isDebugEnabled()) {
            String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
            logger.debug(msg);
        }
    }

    public static void monitor(String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        if (monitorLogger.isInfoEnabled()) {
            String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
            monitorLogger.info(msg);
        }
    }

    public static void info(Logger logger, String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        if (logger.isInfoEnabled()) {
            String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
            logger.info(msg);
        }
    }

    public static void info(Logger logger, String template) {
        if (logger.isInfoEnabled()) {
            String msg = LoggerUtil.addUniqueId(template);
            logger.info(msg);
        }
    }

    private static void processParams(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof BaseEnum) {
                parameters[i] = ((BaseEnum)parameters[i]).getMsg();
            }
            parameters[i] = String.format("[%s]", parameters[i]);
        }
    }

    public static void warn(Logger logger, String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
        logger.warn(msg);
    }

    public static void warn(Throwable e, Logger logger, String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
        logger.warn(msg, e);
    }

    public static void error(Throwable e, Logger logger, String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
        logger.error(msg, e);
    }

    public static void error(Logger logger, String template, Object ... parameters) {
        LoggerUtil.processParams(parameters);
        String msg = LoggerUtil.addUniqueId(MessageFormat.format(template, parameters));
        logger.error(msg);
    }

    public static void error(Logger logger, String template) {
        String msg = LoggerUtil.addUniqueId(template);
        logger.error(msg);
    }

    private static String addUniqueId(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append("[");
        sb.append(TracerUtil.get());
        sb.append("]");
        return sb.toString();
    }
}

