/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JacksonUtil() {
    }

    public static ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String obj2json(Object obj) throws Exception {
        return objectMapper.writeValueAsString(obj);
    }

    public static String obj2jsonIgnoreNull(Object obj) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString(obj);
    }

    public static <T> T json2pojo(String jsonString, Class<T> clazz) throws Exception {
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return (T)objectMapper.readValue(jsonString, clazz);
    }

    public static <T> Map<String, Object> json2map(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return (Map)mapper.readValue(jsonString, Map.class);
    }

    public static <T> Map<String, T> json2map(String jsonString, Class<T> clazz) throws Exception {
        Map map = (Map)objectMapper.readValue(jsonString, new TypeReference<Map<String, T>>(){});
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JacksonUtil.map2pojo((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static Map<String, Object> json2mapDeeply(String json) throws Exception {
        return JacksonUtil.json2MapRecursion(json, objectMapper);
    }

    private static List<Object> json2ListRecursion(String json, ObjectMapper mapper) throws Exception {
        if (json == null) {
            return null;
        }
        List list = (List)mapper.readValue(json, List.class);
        for (Object obj : list) {
            if (obj == null || !(obj instanceof String)) continue;
            String str = (String)obj;
            if (str.startsWith("[")) {
                obj = JacksonUtil.json2ListRecursion(str, mapper);
                continue;
            }
            if (!obj.toString().startsWith("{")) continue;
            obj = JacksonUtil.json2MapRecursion(str, mapper);
        }
        return list;
    }

    private static Map<String, Object> json2MapRecursion(String json, ObjectMapper mapper) throws Exception {
        if (json == null) {
            return null;
        }
        Map map = (Map)mapper.readValue(json, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj == null || !(obj instanceof String)) continue;
            String str = (String)obj;
            if (str.startsWith("[")) {
                List<Object> list = JacksonUtil.json2ListRecursion(str, mapper);
                map.put(entry.getKey(), list);
                continue;
            }
            if (!str.startsWith("{")) continue;
            Map<String, Object> mapRecursion = JacksonUtil.json2MapRecursion(str, mapper);
            map.put(entry.getKey(), mapRecursion);
        }
        return map;
    }

    public static <T> List<T> json2list(String jsonArrayStr, Class<T> clazz) throws Exception {
        JavaType javaType = JacksonUtil.getCollectionType(ArrayList.class, clazz);
        List lst = (List)objectMapper.readValue(jsonArrayStr, javaType);
        return lst;
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> T map2pojo(Map map, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)map, clazz);
    }

    public static String mapToJson(Map map) {
        try {
            return objectMapper.writeValueAsString((Object)map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static <T> T obj2pojo(Object obj, Class<T> clazz) {
        return (T)objectMapper.convertValue(obj, clazz);
    }
}

