/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import cn.com.chinalife.wings.util.DateUtil;
import cn.com.chinalife.wings.util.HashUtil;
import cn.com.chinalife.wings.util.RandomNumberGenerateUtil;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class IdGenerateUtil {
    private static final String SEED_COULD_NOT_BE_EMPTY = "\u79cd\u5b50\u5b57\u7b26\u4e32\u4e0d\u53ef\u4e3a\u7a7a";

    public static String getRandomID(String seed) {
        if (StringUtils.isEmpty((CharSequence)seed)) {
            throw new IllegalArgumentException(SEED_COULD_NOT_BE_EMPTY);
        }
        StringBuilder str = new StringBuilder();
        str.append(DateUtil.parseDateToStr(new Date(), "yyyyMMddHHmmssSSS"));
        str.append(HashUtil.getStringFormat(seed, 6));
        str.append(RandomNumberGenerateUtil.getRandomNumberGenerate(7));
        return str.toString();
    }

    public static String getBase64UUID() {
        return Base64.encodeBase64String((byte[])IdGenerateUtil.getUUID().getBytes());
    }

    public static String getUUID() {
        String seed = DateUtil.parseDateToStr(new Date(), "yyyyMMddHHmmssSSS");
        return IdGenerateUtil.getRandomID(seed);
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>(500);
        for (int t = 0; t < 500; ++t) {
            String uuid = IdGenerateUtil.getBase64UUID();
            System.out.println(uuid);
            if (map.containsKey(uuid)) {
                System.out.println("=============\u9047\u5230\u91cd\u590d\u7684\u4e86");
                continue;
            }
            map.put(uuid, uuid);
        }
    }
}

