/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util.EncryptUtil;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class EncryptUtil {
    private static Logger logger = LoggerFactory.getLogger(EncryptUtil.class);
    private static final String KEY_SHA = "SHA";
    private static final String MD5 = "MD5";

    public static String sha(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            return "";
        }
        try {
            MessageDigest sha = MessageDigest.getInstance(KEY_SHA);
            sha.update(data.getBytes("utf-8"));
            byte[] bytes = sha.digest();
            return EncryptUtil.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            logger.error("\u5b57\u7b26\u4e32\u4f7f\u7528SHA\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String md5(String source) {
        if (StringUtils.isEmpty((Object)source)) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            byte[] bytes = md.digest(source.getBytes("utf-8"));
            return EncryptUtil.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            logger.error("\u5b57\u7b26\u4e32\u4f7f\u7528Md5\u52a0\u5bc6\u5931\u8d25" + source + "' to MD5!", (Throwable)e);
            return null;
        }
    }

    private static String byteArrayToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toHexString(bytes[i] & 0xFF | 0x100).toUpperCase().substring(1, 3));
        }
        return sb.toString();
    }

    public static byte[] encrypt(String content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String encryptString(String content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            String encryptResultStr = EncryptUtil.parseByte2HexStr(result);
            return encryptResultStr;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decrypt(String content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] decryptFrom = EncryptUtil.parseHexStr2Byte(content);
            byte[] result = cipher.doFinal(decryptFrom);
            return new String(result);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String key = "123";
        System.out.println(EncryptUtil.sha(key));
        System.out.println(EncryptUtil.md5(key));
        String str = "7B924BD99F0159EF82B9EA8467A0F9425EB5028E54574C4F1E375D1726D2A097FD96FBE0CF112B068F74AF0AFE16F6785B9B3875E873FAD89B7A88B16F7513FB8CC9C4644CA1CB3944C56431BF589BC630004F9D1D0DEB5F861A7B26321FC0B6FC6BCF226C899156B5964458F7D13FE7FFD8C15502FE3768797FE93972E19380DF488E9620C18117CC6B36500DB490D8310DDD3152EDD5A08DBAE615FB7F64AE1CFC0D1B7D286F11AD8FF4F4053CC9CC";
        String DencryptJson = new String(EncryptUtil.decrypt(EncryptUtil.parseHexStr2Byte(str), "3$%#$7sfdsS67dSgf53"));
        System.out.println(URLDecoder.decode(DencryptJson, "UTF-8"));
        String JsonInput = "{\n\"Name\":\"\u6b23\u6b23\",\n\"Branch\":\"\u5e7f\u4e1c\u7701\u5206\u516c\u53f8\",\n\"PhoneNum\":\"13344445555\",\n\"Id\":\"1810005661\",\n}";
        String encodeJson = URLEncoder.encode(JsonInput, "UTF-8");
        String EncryptJson = new String(EncryptUtil.parseByte2HexStr(EncryptUtil.encrypt(encodeJson, "3$%#$7sfdsS67dSgf53")));
        System.out.println(EncryptJson);
    }
}

