/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    private static final String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};
    public static final String STRING_MONDAY = "\u661f\u671f\u4e00";
    public static final String STRING_TUESDAY = "\u661f\u671f\u4e8c";
    public static final String STRING_WEDNESDAY = "\u661f\u671f\u4e09";
    public static final String STRING_THURSDAY = "\u661f\u671f\u56db";
    public static final String STRING_FRIDAY = "\u661f\u671f\u4e94";
    public static final String STRING_SATURDAY = "\u661f\u671f\u516d";
    public static final String STRING_SUNDAY = "\u661f\u671f\u65e5";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SSSS = "yyyyMMddHHmmssSSS";

    public static String parseDateToStr(Date date, String parsePatterns) {
        return DateFormatUtils.format((Date)date, (String)parsePatterns);
    }

    public static Integer parseDateToInteger(Date date, String parsePatterns) {
        String parseStr = DateFormatUtils.format((Date)date, (String)parsePatterns);
        return Integer.parseInt(parseStr);
    }

    public static String parseDateToStr(java.sql.Date date, String parsePatterns) {
        return DateFormatUtils.format((Date)date, (String)parsePatterns);
    }

    public static Calendar parseDateToCalendar(Date date) {
        return DateUtils.toCalendar((Date)date);
    }

    public static String parseDateToStr(Timestamp timestamp, String parsePatterns) {
        return DateFormatUtils.format((Date)timestamp, (String)parsePatterns);
    }

    public static String parseCalendarToDate(Calendar calendar, String pattern) {
        return DateFormatUtils.format((Calendar)calendar, (String)pattern);
    }

    public static Date parseStrToDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String parseLongToStr(long millis, String pattern) {
        return DateFormatUtils.format((long)millis, (String)pattern);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.addWeeks((Date)date, (int)amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.addDays((Date)date, (int)amount);
    }

    public static Date addMonth(Date date, int monthNum) {
        return DateUtils.addMonths((Date)date, (int)monthNum);
    }

    public static String addMonthStr(Date date, int monthNum, String parsePatterns) {
        Date addDate = DateUtil.addMonth(date, monthNum);
        return DateUtil.parseDateToStr(addDate, parsePatterns);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.addHours((Date)date, (int)amount);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return DateUtils.isSameDay((Calendar)cal1, (Calendar)cal2);
    }

    private static long parseDateToLong(Date date) {
        Calendar calendar = DateUtils.toCalendar((Date)date);
        return calendar.getTimeInMillis();
    }

    public static boolean isDateBetweenAAndB(Date date, long startTime, long endTime) {
        long dateLong = DateUtil.parseDateToLong(date);
        return dateLong >= startTime && dateLong <= endTime;
    }

    public static boolean isDateBetweenAAndB(Date date, Date startDate, Date endDate) {
        long dateLong = DateUtil.parseDateToLong(date);
        long startLong = DateUtil.parseDateToLong(startDate);
        long endLong = DateUtil.parseDateToLong(endDate);
        return dateLong >= startLong && dateLong <= endLong;
    }

    public static boolean isDateBetweenAAndB(Timestamp timeStamp, long startTime, long endTime) {
        long dateLong = timeStamp.getTime();
        return dateLong >= startTime && dateLong <= endTime;
    }

    public static String getWeeek(Date date) {
        Calendar calendar = DateUtil.parseDateToCalendar(date);
        int dayOfWeek = calendar.get(7);
        switch (dayOfWeek) {
            case 1: {
                return STRING_SUNDAY;
            }
            case 2: {
                return STRING_MONDAY;
            }
            case 3: {
                return STRING_TUESDAY;
            }
            case 4: {
                return STRING_WEDNESDAY;
            }
            case 5: {
                return STRING_THURSDAY;
            }
            case 6: {
                return STRING_FRIDAY;
            }
        }
        return STRING_SATURDAY;
    }

    public static boolean isLaterHours(int hour) {
        Calendar calendar = DateUtil.parseDateToCalendar(new Date());
        int dateHour = calendar.get(11);
        return dateHour >= hour;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.isLaterHours(15));
    }
}

