/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.DigestUtils;

public class ConvertBeanUtil {
    private static Logger logger = LoggerFactory.getLogger(ConvertBeanUtil.class);
    private static ConcurrentHashMap<String, BeanCopier> cache = new ConcurrentHashMap();

    private ConvertBeanUtil() {
    }

    public static <T> T copyBeanProperties(Class source, Class<T> target, Object sourceObj, boolean useConverter) {
        T t;
        if (sourceObj == null) {
            return null;
        }
        try {
            t = target.newInstance();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
        String key = source.getSimpleName() + target.getSimpleName();
        BeanCopier copier = cache.get(key);
        if (copier == null) {
            copier = ConvertBeanUtil.createBeanCopier(source, target, useConverter, key);
        }
        copier.copy(sourceObj, t, null);
        return t;
    }

    public static <T> T copyBeanProperties(Object sourceObj, T target) {
        return ConvertBeanUtil.copyBeanProperties(sourceObj, target, false);
    }

    public static <T> T copyBeanProperties(Object sourceObj, T target, boolean useConverter) {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{sourceObj, target})) {
            return null;
        }
        String key = sourceObj.getClass().getSimpleName() + target.getClass().getSimpleName();
        BeanCopier copier = cache.get(key);
        if (copier == null) {
            copier = ConvertBeanUtil.createBeanCopier(sourceObj.getClass(), target.getClass(), useConverter, key);
        }
        copier.copy(sourceObj, target, null);
        return target;
    }

    public static <T> List<T> copyListBeanPropertiesToList(List<?> sourceObjs, List<T> targets, Class<T> targetType) {
        if (sourceObjs == null || targets == null || targetType == null) {
            return null;
        }
        for (Object o : sourceObjs) {
            try {
                T t = targetType.newInstance();
                targets.add(ConvertBeanUtil.copyBeanProperties(o, t, false));
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("", (Throwable)e);
            }
        }
        return targets;
    }

    private static String getHashKey(String str) {
        if (str == null) {
            return null;
        }
        return DigestUtils.md5DigestAsHex((byte[])str.getBytes());
    }

    private static BeanCopier createBeanCopier(Class sourceClass, Class targetClass, boolean useConverter, String cacheKey) {
        BeanCopier copier = BeanCopier.create((Class)sourceClass, (Class)targetClass, (boolean)useConverter);
        cache.putIfAbsent(cacheKey, copier);
        return copier;
    }

    public static Object mapToObject(Map map, Class<?> beanClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        BeanUtils.populate(obj, (Map)map);
        return obj;
    }
}

