/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.util;

import cn.com.chinalife.wings.util.example.CheckException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CheckUtil {
    public static final String JPG = ".jpg";
    public static final String PNG = ".png";
    public static final String ZIP = ".zip";
    public static final String IPA = ".ipa";
    public static final String APK = ".apk";
    public static final String SVG = ".svg";
    public static final String GIF = ".gif";
    public static final String AVI = ".avi";
    public static final String WMV = ".wmv";
    public static final String MP4 = ".mp4";
    public static final String RM = ".rm";
    public static final String RMVB = ".rmvb";
    public static final String MKV = ".mkv";
    public static final String JAVA = ".java";
    public static final String PROPERTIES = ".properties";
    public static final String XML = ".xml";
    public static final String NONE = "NONE";
    public static final List<String> LEGAL_SUFFIX = Arrays.asList(".jpg", ".png", ".zip", ".ipa", ".apk", ".svg", ".gif", ".avi", ".wmv", ".mp4", ".rm", ".rmvb", ".mkv");
    public static final List<String> JAVA_SUFFIX = Arrays.asList(".java", ".properties", ".xml");
    public static final List<String> JAVA_NONE_SUFFIX = Arrays.asList(".java", ".properties", ".xml", "NONE");

    private CheckUtil() {
    }

    public static void notNull(String instanceName, Object instance) {
        if (instance == null) {
            throw new CheckException("\u5bf9\u8c61\uff1a " + instanceName + " \u4e0d\u80fd\u4e3aNULL");
        }
    }

    public static void notBlank(String propertyName, String propertyValue) {
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            throw new CheckException("\u5b57\u6bb5\uff1a " + propertyName + " \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkImg(String suffix) {
        if (!LEGAL_SUFFIX.contains(suffix)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u7684\u6587\u4ef6\u5fc5\u987b\u7b26\u5408\u6587\u4ef6\u540e\u7f00\u8981\u6c42\uff0c\u5408\u6cd5\u7684\u6587\u4ef6\u540e\u7f00\u4e3a:" + LEGAL_SUFFIX.toString());
        }
    }

    public static void checkJavaAndNone(String suffix) {
        if (!JAVA_NONE_SUFFIX.contains(suffix)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u7684\u6587\u4ef6\u5fc5\u987b\u7b26\u5408\u6587\u4ef6\u540e\u7f00\u8981\u6c42\uff0c\u5408\u6cd5\u7684\u6587\u4ef6\u540e\u7f00\u4e3a:" + LEGAL_SUFFIX.toString());
        }
    }

    public static void checkJava(String suffix) {
        if (!JAVA_SUFFIX.contains(suffix)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u7684\u6587\u4ef6\u5fc5\u987b\u7b26\u5408\u6587\u4ef6\u540e\u7f00\u8981\u6c42\uff0c\u5408\u6cd5\u7684\u6587\u4ef6\u540e\u7f00\u4e3a:" + LEGAL_SUFFIX.toString());
        }
    }

    public static void checkMethodParameters(Object ... paras) {
        for (Object para : paras) {
            boolean illegal;
            boolean bl = illegal = para == null || para instanceof String && ((String)para).isEmpty();
            if (!illegal) continue;
            throw new IllegalArgumentException("Method Parameters is Empty!");
        }
    }
}

