/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.autoconfigure.rmi;

import cn.com.chinalife.wings.rmi.core.config.RmiGrayConfigCenter;
import cn.com.chinalife.wings.rmi.core.core.CoreHeaderInterceptor;
import cn.com.chinalife.wings.rmi.httptools.base.WingsHttpUtil;
import cn.com.chinalife.wings.rmi.httptools.base.impl.HttpRestTemplateUtil;
import cn.com.chinalife.wings.rmi.httptools.base.impl.HttpUtil;
import cn.com.chinalife.wings.rmi.httptools.base.impl.SimpleWingsHttpUtilImpl;
import cn.com.chinalife.wings.rmi.httptools.config.PressureFlagConfig;
import cn.com.chinalife.wings.rmi.httptools.config.RestTemplateCenterConfig;
import cn.com.chinalife.wings.rmi.httptools.config.RestTemplateConfig;
import cn.com.chinalife.wings.rmi.httptools.interceptor.HttpAndRestAspect;
import cn.com.chinalife.wings.rmi.httptools.interfaceutil.ExceptionUtils;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alibaba.sentinel.annotation.SentinelRestTemplate;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={WingsHttpUtil.class})
@AutoConfigureAfter(value={RestTemplateCenterConfig.class, PressureFlagConfig.class})
@EnableConfigurationProperties(value={RestTemplateCenterConfig.class, PressureFlagConfig.class})
public class WingsRmiAutoConfigure {
    private RestTemplateCenterConfig restTemplateCenterConfig;
    private PressureFlagConfig pressureFlagConfig;
    @Autowired
    private CoreHeaderInterceptor coreHeaderInterceptor;
    @Autowired
    private RmiGrayConfigCenter rmiGrayConfigCenter;
    private RestTemplate restTemplate;

    @Bean
    public CoreHeaderInterceptor coreHeaderInterceptorFactory() {
        this.coreHeaderInterceptor = new CoreHeaderInterceptor();
        return this.coreHeaderInterceptor;
    }

    @Bean
    public RmiGrayConfigCenter createGrayConfigCenter() {
        this.rmiGrayConfigCenter = new RmiGrayConfigCenter();
        return this.rmiGrayConfigCenter;
    }

    @Autowired
    public WingsRmiAutoConfigure(RestTemplateCenterConfig config1, PressureFlagConfig config2) {
        this.restTemplateCenterConfig = config1;
        this.pressureFlagConfig = config2;
    }

    @PostConstruct
    @Bean
    @LoadBalanced
    @SentinelRestTemplate(fallbackClass=ExceptionUtils.class, fallback="handleFallback", blockHandler="handleBlock", blockHandlerClass=ExceptionUtils.class)
    public RestTemplate restTemplate() {
        this.restTemplate = new RestTemplateConfig(this.restTemplateCenterConfig, this.coreHeaderInterceptor, this.rmiGrayConfigCenter).restTemplate();
        return this.restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpAndRestAspect wingsRestAspect() {
        return new HttpAndRestAspect(this.pressureFlagConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionUtils getExceptionUtils() {
        return new ExceptionUtils(this.pressureFlagConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public WingsHttpUtil simpleWingsHttpUtil() {
        return new SimpleWingsHttpUtilImpl(new HttpUtil(this.restTemplateCenterConfig), new HttpRestTemplateUtil(this.restTemplate));
    }
}

