/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.kibana.encoding;

import ch.qos.logback.core.Layout;
import cn.com.chinalife.wings.kibana.encoding.KafkaMessageEncoderBase;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class LayoutKafkaMessageEncoder<E>
extends KafkaMessageEncoderBase<E> {
    private static final String OUT_SIZE = "1000000";
    private Layout<E> layout;
    private Charset charset;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public LayoutKafkaMessageEncoder() {
    }

    public LayoutKafkaMessageEncoder(Layout<E> layout, Charset charset) {
        this.layout = layout;
        this.charset = charset;
    }

    @Override
    public void start() {
        if (this.charset == null) {
            this.addInfo("No charset specified for PatternLayoutKafkaEncoder. Using default UTF8 encoding.");
            this.charset = UTF8;
        }
        super.start();
    }

    @Override
    public byte[] doEncode(E event) {
        String message = this.layout.doLayout(event);
        String messageValue = this.getMessageValue(message);
        return messageValue.getBytes(this.charset);
    }

    private String getMessageValue(String message) {
        String prefix = message.substring(0, message.lastIndexOf("-"));
        String suffix = message.substring(message.lastIndexOf("-") + 1);
        String suffixStr = suffix.substring(suffix.indexOf("]"));
        String content = suffix.substring(0, suffix.indexOf("]"));
        String getContent = this.setSenderMessageSize(content);
        return prefix + "-" + getContent + suffixStr;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private String setSenderMessageSize(String message) {
        try {
            return this.setMessageValue(message, OUT_SIZE);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private String setMessageValue(String str, String outSize) throws UnsupportedEncodingException {
        int i;
        int outLength = Integer.parseInt(outSize);
        if (str.length() < outLength) {
            return str;
        }
        byte[] bytes = str.getBytes("Unicode");
        int n = 0;
        for (i = 2; i < bytes.length && n < outLength; ++i) {
            if (i % 2 == 1) {
                ++n;
                continue;
            }
            if (bytes[i] == 0) continue;
            ++n;
        }
        if (i % 2 == 1) {
            i = bytes[i - 1] != 0 ? --i : ++i;
        }
        return new String(bytes, 0, i, "Unicode");
    }
}

