/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.kibana;

import ch.qos.logback.core.Appender;
import cn.com.chinalife.wings.kibana.KafkaAppender;
import cn.com.chinalife.wings.kibana.util.TakeActiveProfiles;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WingsKafkaAppender<E>
extends KafkaAppender<E> {
    public static final String CLASS_PATH = "wings-logging-kibana.properties";
    private static final Logger logger = LoggerFactory.getLogger(WingsKafkaAppender.class);

    public WingsKafkaAppender() {
        String[] actives = TakeActiveProfiles.activeProfile;
        String classPathsKafka = CLASS_PATH;
        try {
            for (String active : actives) {
                if (!StringUtils.isNotEmpty((CharSequence)active)) continue;
                String[] str = classPathsKafka.split("\\.");
                classPathsKafka = str[0] + "-" + active + "." + str[1];
                if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathsKafka) != null && ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathsKafka).available() > 0) {
                    logger.info("wings\u53cb\u60c5\u63d0\u9192\uff0c\u5f53\u524dkibana\u7684activeProfile\u4e3a\uff1a" + active);
                    break;
                }
                classPathsKafka = CLASS_PATH;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        logger.info("wings\u53cb\u60c5\u63d0\u9192\uff0c\u5f53\u524dkibana\u52a0\u8f7d\u7684\u914d\u7f6e\u6587\u4ef6\u4e3a\uff1a" + classPathsKafka);
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathsKafka);
        this.addProducerBootstrapServers(in);
        File file = null;
        try {
            URL url = WingsKafkaAppender.class.getClassLoader().getResource(classPathsKafka);
            file = new File(url.getPath());
            if (file.exists()) {
                in = new FileInputStream(file);
                this.addProducerBootstrapServers(in);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void addProducerBootstrapServers(InputStream in) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line) || line.contains("#") || !line.startsWith("wings.logback.kafka.brokers=")) continue;
                line = line.trim().substring("wings.logback.kafka.brokers=".length());
                this.addProducerConfig("bootstrap.servers=" + line);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Appender<E> getAppender(String name) {
        return super.getAppender(name);
    }

    @Override
    public void addProducerConfig(String keyValue) {
        String[] split = keyValue.split("=", 2);
        if (split.length == 2) {
            this.addProducerConfigValue(split[0], split[1]);
        }
    }
}

