/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.kibana;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import cn.com.chinalife.wings.kibana.delivery.BlockingDeliveryStrategy;
import cn.com.chinalife.wings.kibana.delivery.DeliveryStrategy;
import cn.com.chinalife.wings.kibana.encoding.KafkaMessageEncoder;
import cn.com.chinalife.wings.kibana.keying.KeyingStrategy;
import cn.com.chinalife.wings.kibana.keying.RoundRobinKeyingStrategy;
import cn.com.chinalife.wings.kibana.util.TakeActiveProfiles;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class KafkaAppenderConfig<E>
extends UnsynchronizedAppenderBase<E>
implements AppenderAttachable<E> {
    protected String topic = null;
    protected KafkaMessageEncoder<E> encoder = null;
    protected KeyingStrategy<? super E> keyingStrategy = null;
    protected DeliveryStrategy deliveryStrategy;
    public static final String METADATA_FETCH_TIMEOUT_CONFIG = "metadata.fetch.timeout.ms";
    public static final String TIMEOUT_CONFIG = "timeout.ms";
    public static final String BLOCK_ON_BUFFER_FULL_CONFIG = "block.on.buffer.full";
    private static final String CLASS_PATH = "wings-logging-kibana.properties";
    public static final Set<String> KNOWN_PRODUCER_CONFIG_KEYS = new HashSet<String>();
    public static final Map<String, String> DEPRECATED_PRODUCER_CONFIG_KEYS = new HashMap<String, String>();
    protected Map<String, Object> producerConfig = new HashMap<String, Object>();

    protected boolean checkPrerequisites() {
        boolean errorFree = true;
        if (this.producerConfig.get("bootstrap.servers") == null) {
            this.addError("No \"bootstrap.servers\" set for the appender named [\"" + this.name + "\"].");
            errorFree = false;
        }
        if (this.topic == null) {
            this.addError("No topic set for the appender named [\"" + this.name + "\"].");
            errorFree = false;
        }
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [\"" + this.name + "\"].");
            errorFree = false;
        }
        if (this.keyingStrategy == null) {
            this.addInfo("No partitionStrategy set for the appender named [\"" + this.name + "\"]. Using default RoundRobin strategy.");
            this.keyingStrategy = new RoundRobinKeyingStrategy();
        }
        if (this.deliveryStrategy == null) {
            this.addInfo("No sendStrategy set for the appender named [\"" + this.name + "\"]. Using default Blocking strategy.");
            this.deliveryStrategy = new BlockingDeliveryStrategy();
        }
        return errorFree;
    }

    public void setEncoder(KafkaMessageEncoder<E> layout) {
        this.encoder = layout;
    }

    public void setTopic(String topic) {
        String[] actives = TakeActiveProfiles.activeProfile;
        String classPathsKafka = CLASS_PATH;
        try {
            for (String active : actives) {
                if (!StringUtils.isNotEmpty((CharSequence)active)) continue;
                String[] str = classPathsKafka.split("\\.");
                classPathsKafka = str[0] + "-" + active + "." + str[1];
                if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathsKafka) == null || ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathsKafka).available() <= 0) {
                    classPathsKafka = CLASS_PATH;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathsKafka);
        this.addProducerTopic(topic, in);
        try {
            URL url = KafkaAppenderConfig.class.getClassLoader().getResource(classPathsKafka);
            File file = new File(url.getPath());
            if (file.exists()) {
                in = new FileInputStream(file);
                this.addProducerTopic(topic, in);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addProducerTopic(String topic, InputStream in) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line) || line.contains("#") || !line.startsWith("wings.logback.kafka.topic")) continue;
                topic = line.trim().substring("wings.logback.kafka.topic=".length());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.topic = topic;
    }

    public void setKeyingStrategy(KeyingStrategy<? super E> keyingStrategy) {
        this.keyingStrategy = keyingStrategy;
    }

    public void addProducerConfig(String keyValue) {
        String[] split = keyValue.split("=", 2);
        if (split.length == 2) {
            this.addProducerConfigValue(split[0], split[1]);
        }
    }

    public void addProducerConfigValue(String key, Object value) {
        if (!KNOWN_PRODUCER_CONFIG_KEYS.contains(key)) {
            this.addWarn("The key \"" + key + "\" is now a known kafka producer config key.");
        }
        if (DEPRECATED_PRODUCER_CONFIG_KEYS.containsKey(key)) {
            StringBuilder deprecationMessage = new StringBuilder("The key \"" + key + "\" is deprectated in kafka and may be removed in a future version.");
            if (DEPRECATED_PRODUCER_CONFIG_KEYS.get(key) != null) {
                deprecationMessage.append(" Consider using key \"").append(DEPRECATED_PRODUCER_CONFIG_KEYS.get(key)).append("\" instead.");
            }
            this.addWarn(deprecationMessage.toString());
        }
        this.producerConfig.put(key, value);
    }

    public Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    public void setDeliveryStrategy(DeliveryStrategy deliveryStrategy) {
        this.deliveryStrategy = deliveryStrategy;
    }

    static {
        KNOWN_PRODUCER_CONFIG_KEYS.add("bootstrap.servers");
        KNOWN_PRODUCER_CONFIG_KEYS.add(METADATA_FETCH_TIMEOUT_CONFIG);
        DEPRECATED_PRODUCER_CONFIG_KEYS.put(METADATA_FETCH_TIMEOUT_CONFIG, "max.block.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("metadata.max.age.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("batch.size");
        KNOWN_PRODUCER_CONFIG_KEYS.add("buffer.memory");
        KNOWN_PRODUCER_CONFIG_KEYS.add("acks");
        KNOWN_PRODUCER_CONFIG_KEYS.add(TIMEOUT_CONFIG);
        DEPRECATED_PRODUCER_CONFIG_KEYS.put(METADATA_FETCH_TIMEOUT_CONFIG, "request.timeout.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("linger.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("client.id");
        KNOWN_PRODUCER_CONFIG_KEYS.add("send.buffer.bytes");
        KNOWN_PRODUCER_CONFIG_KEYS.add("receive.buffer.bytes");
        KNOWN_PRODUCER_CONFIG_KEYS.add("max.request.size");
        KNOWN_PRODUCER_CONFIG_KEYS.add("reconnect.backoff.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add(BLOCK_ON_BUFFER_FULL_CONFIG);
        DEPRECATED_PRODUCER_CONFIG_KEYS.put(METADATA_FETCH_TIMEOUT_CONFIG, null);
        KNOWN_PRODUCER_CONFIG_KEYS.add("retries");
        KNOWN_PRODUCER_CONFIG_KEYS.add("retry.backoff.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("compression.type");
        KNOWN_PRODUCER_CONFIG_KEYS.add("metrics.sample.window.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("metrics.num.samples");
        KNOWN_PRODUCER_CONFIG_KEYS.add("metric.reporters");
        KNOWN_PRODUCER_CONFIG_KEYS.add("max.in.flight.requests.per.connection");
        KNOWN_PRODUCER_CONFIG_KEYS.add("key.serializer");
        KNOWN_PRODUCER_CONFIG_KEYS.add("value.serializer");
        KNOWN_PRODUCER_CONFIG_KEYS.add("connections.max.idle.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("partitioner.class");
        KNOWN_PRODUCER_CONFIG_KEYS.add("max.block.ms");
        KNOWN_PRODUCER_CONFIG_KEYS.add("request.timeout.ms");
    }
}

