/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.wings.database;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DruidPropertiesAutoConfiguration
implements EnvironmentPostProcessor,
ApplicationListener<ApplicationEvent> {
    private final YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
    private static final int FIRSTKEY = 0;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ClassPathResource path = new ClassPathResource("/application-druid.yml");
        List<PropertySource<?>> propertySource = this.loadYaml((Resource)path);
        PropertySource<?> newpropertySource = this.dealConfig(environment, propertySource);
        if (newpropertySource != null && newpropertySource.getSource() != null && ((LinkedHashMap)newpropertySource.getSource()).size() > 0) {
            environment.getPropertySources().addLast(newpropertySource);
        } else {
            environment.getPropertySources().addLast(propertySource.get(0));
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
    }

    private List<PropertySource<?>> loadYaml(Resource path) {
        if (!path.exists()) {
            throw new IllegalArgumentException("Resource " + path + " does not exist");
        }
        try {
            return this.loader.load("application-druid", path);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load yaml configuration from " + path, ex);
        }
    }

    private PropertySource<?> dealConfig(ConfigurableEnvironment environment, List<PropertySource<?>> propertySource) {
        String activeProfile = environment.getActiveProfiles()[0];
        MutablePropertySources realConfig = environment.getPropertySources();
        PropertySource s = realConfig != null ? realConfig.get("applicationConfig: [classpath:/application-" + activeProfile + ".properties]") : null;
        HashSet<String> datasource = new HashSet<String>();
        if (s != null) {
            LinkedHashMap str = (LinkedHashMap)s.getSource();
            for (Map.Entry entry : str.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().toString().contains("datasource")) continue;
                String[] dbkeys = entry.getKey().toString().split("\\.");
                datasource.add(dbkeys[2]);
            }
        } else {
            return null;
        }
        LinkedHashMap newHashMap = new LinkedHashMap();
        for (String dbtype : datasource) {
            PropertySource<?> curPS = propertySource.get(0);
            LinkedHashMap curHashMap = (LinkedHashMap)curPS.getSource();
            for (Map.Entry curentry : curHashMap.entrySet()) {
                if (curentry.getKey().toString().startsWith("spring.datasource.druid")) {
                    String[] curdbkeys = curentry.getKey().toString().split("\\.");
                    String newkey = "";
                    for (int i = 0; i < curdbkeys.length; ++i) {
                        newkey = i == 0 ? curdbkeys[i] : (i == 2 ? newkey + "." + curdbkeys[i] + "." + dbtype : newkey + "." + curdbkeys[i]);
                    }
                    newHashMap.put(newkey, curentry.getValue());
                    continue;
                }
                newHashMap.put((String)curentry.getKey(), curentry.getValue());
            }
        }
        return newHashMap.size() > 0 ? new OriginTrackedMapPropertySource(propertySource.get(0).getName(), newHashMap) : null;
    }
}

