/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.thread;

import cn.com.chinalife.thread.RefectInsurAmount;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutilThreadInsurSum
implements Callable<BigDecimal> {
    private String riskCode;
    private String riskType;
    private String clzzName;
    private String methodName;
    private volatile int startIndex;
    private volatile int endIndex;
    private volatile BigDecimal toTalsum = BigDecimal.ZERO;

    public MutilThreadInsurSum(int startIndex, int endIndex, String clzzName, String methodName, String riskCode, String riskType) {
        this.riskCode = riskCode;
        this.riskType = riskType;
        this.clzzName = clzzName;
        this.methodName = methodName;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public MutilThreadInsurSum() {
    }

    @Override
    public BigDecimal call() throws Exception {
        for (int index = this.startIndex; index <= this.endIndex; ++index) {
            this.toTalsum = this.toTalsum.add(RefectInsurAmount.excute(this.clzzName, this.methodName, this.riskCode, this.riskType));
        }
        return this.toTalsum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getDataSum(int number, int threadNumber, String clazzName, String methodName, String riskCode, String riskType) {
        CopyOnWriteArrayList<Future<BigDecimal>> taskList = new CopyOnWriteArrayList<Future<BigDecimal>>();
        ExecutorService executorService = Executors.newFixedThreadPool(threadNumber);
        try {
            for (int index = 0; index < threadNumber; ++index) {
                int startIndex = number * index / threadNumber + 1;
                int endIndex = number * (index + 1) / threadNumber;
                Future<BigDecimal> future = executorService.submit(new MutilThreadInsurSum(startIndex, endIndex, clazzName, methodName, riskCode, riskType));
                future.get();
                taskList.add(future);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
        }
        this.toTalsum = this.getFutureSum(taskList);
        return this.toTalsum;
    }

    public BigDecimal getFutureSum(List<Future<BigDecimal>> taskList) {
        BigDecimal threadSum = BigDecimal.ZERO;
        if (taskList.size() == 0) {
            return BigDecimal.ZERO;
        }
        try {
            for (Future<BigDecimal> task : taskList) {
                threadSum = threadSum.add(task.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return threadSum;
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        MutilThreadInsurSum shareData = new MutilThreadInsurSum();
        String riskType = "1";
        String riskCode = "657";
        String methodName = "dealMain";
        String clazzName = "cn.com.chinalife.thread.DealMain";
        BigDecimal sum = shareData.getDataSum(20000, 8, clazzName, methodName, riskCode, riskType);
        System.out.println("\u6700\u7ec8\u8fd0\u884c\u7684\u7ed3\u679c:" + sum);
        long endTime = System.currentTimeMillis();
        System.out.println("\u6700\u7ec8\u8fd0\u884c\u7684\u7ed3\u679c\u65f6\u95f4:" + (double)(endTime - startTime) / 1000.0);
    }
}

