/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.util.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.newtouch.util.ClassUtil;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.string.StrUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JsonUtilOld {
    private static ObjectMapper initObjectMapper() {
        return JsonUtilOld.initObjectMapper(true);
    }

    private static ObjectMapper initObjectMapper(boolean isFormatTimestamps) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        mapper.setTimeZone(TimeZone.getDefault());
        if (isFormatTimestamps) {
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mapper.setDateFormat((DateFormat)d);
        }
        mapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object arg0, JsonGenerator arg1, SerializerProvider arg2) throws IOException {
                arg1.writeString("");
            }
        });
        return mapper;
    }

    public static void initJsonObject(Map<String, Object> map, String key, String value) {
        if (map == null) {
            return;
        }
        String[] keyArray = (key = key.replaceAll("]", "").replace("[", "#")).split("#");
        if (keyArray.length < 2) {
            return;
        }
        if (keyArray[1].toLowerCase().endsWith("date") && !StrUtil.isNull((Object)value) && DateUtil.isValidDate((String)value)) {
            map.put(keyArray[1], DateUtil.string2Date((Object)value));
        } else {
            map.put(keyArray[1], value);
        }
    }

    public static List<Map<String, Object>> json2List(String jsonObj) {
        ObjectMapper mapper = JsonUtilOld.initObjectMapper();
        try {
            return (List)mapper.readValue(jsonObj, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, Map.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> json2List(Object obj, Class<T> requiredType) {
        if (!(obj instanceof List)) {
            throw new RuntimeException("\u5165\u53c2\u5fc5\u987b\u4e3aList\u7c7b\u578b");
        }
        try {
            String jsonObj = JsonUtilOld.formatObject(obj);
            if (StrUtil.isNull((Object)jsonObj)) {
                return new ArrayList();
            }
            ObjectMapper mapper = JsonUtilOld.initObjectMapper();
            return (List)mapper.readValue(jsonObj, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, requiredType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> json2Map(String jsonObj) {
        if (StrUtil.isNull((Object)jsonObj)) {
            return new HashMap<String, Object>();
        }
        try {
            ObjectMapper mapper = JsonUtilOld.initObjectMapper();
            return (Map)mapper.readValue(jsonObj, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T json2Object(String jsonObj, Class<T> requiredType) {
        return JsonUtilOld.json2Object(jsonObj, requiredType, true);
    }

    public static <T> T json2Object(String jsonObj, Class<T> requiredType, boolean isFormatTimestamps) {
        try {
            ObjectMapper mapper = JsonUtilOld.initObjectMapper(isFormatTimestamps);
            return (T)mapper.readValue(jsonObj, requiredType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatJSONArray(List<?> list) {
        try {
            ObjectMapper mapper = JsonUtilOld.initObjectMapper();
            return mapper.writeValueAsString(list);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatJSONObject(Map<?, ?> map) {
        try {
            ObjectMapper mapper = JsonUtilOld.initObjectMapper();
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatObject(Object object) {
        if (object == null) {
            return "";
        }
        try {
            ObjectMapper mapper = JsonUtilOld.initObjectMapper();
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String qiwang = "{\"array3\":[[{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],[{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],\"list_stringtest1\",\"list_stringtest2\",\"list_stringtest3\"],\"\u6027\u522b\":\"\u6295\u4fdd\u4ebaxin_bie\",\"\u59d3\u540d\":\"\u6295\u4fdd\u4ebaxin_ming\",\"maptest\":{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},\"stringtest\":[\"list_stringtest1\",\"list_stringtest2\",\"list_stringtest3\"],\"\u51fa\u751f\u65e5\u671f_date\":\"2015-01-01\",\"\u5b66\u5386\":\"\u6295\u4fdd\u4ebaxue_li\",\"\u56fd\u7c4d\":\"\u6295\u4fdd\u4ebaguo_ji\",\"\u88ab\u4fdd\u4eba\":[{\"\u6027\u522b\":\"\u88ab\u4fdd\u4eba_1_xin_bie\",\"\u59d3\u540d\":\"\u88ab\u4fdd\u4eba_1_xin_ming\",\"\u53d7\u76ca\u4eba\":[{\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_2_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_2_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_2_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_2_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_2_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_2_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_2_chu_sheng_ri_qi\"},{\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_3_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_3_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_3_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_3_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_3_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_3_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_3_chu_sheng_ri_qi\"},{\"array3\":[[{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],[{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],\"list_stringtest1\",\"list_stringtest2\",\"list_stringtest3\"],\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_4_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_4_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_4_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_4_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_4_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_4_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_4_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_4_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_4_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_4_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_4_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_4_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_4_chu_sheng_ri_qi\"}],\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u88ab\u4fdd\u4eba_1_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u88ab\u4fdd\u4eba_1_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u88ab\u4fdd\u4eba_1_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u88ab\u4fdd\u4eba_1_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u88ab\u4fdd\u4eba_1_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u88ab\u4fdd\u4eba_1_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u88ab\u4fdd\u4eba_1_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u88ab\u4fdd\u4eba_1_di_zhi_4\"}],\"\u5b66\u5386\":\"\u88ab\u4fdd\u4eba_1_xue_li\",\"\u56fd\u7c4d\":\"\u88ab\u4fdd\u4eba_1_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u88ab\u4fdd\u4eba_1_chu_sheng_ri_qi\"},{\"\u6027\u522b\":\"\u88ab\u4fdd\u4eba_2_xin_bie\",\"\u59d3\u540d\":\"\u88ab\u4fdd\u4eba_2_xin_ming\",\"\u53d7\u76ca\u4eba\":[{\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_2_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_2_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_2_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_2_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_2_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_2_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_2_chu_sheng_ri_qi\"},{\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_3_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_3_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_3_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_3_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_3_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_3_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_3_chu_sheng_ri_qi\"},{\"array3\":[[{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],[{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],\"list_stringtest1\",\"list_stringtest2\",\"list_stringtest3\"],\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_4_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_4_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_4_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_4_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_4_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_4_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_4_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_4_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_4_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_4_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_4_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_4_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_4_chu_sheng_ri_qi\"}],\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u88ab\u4fdd\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u88ab\u4fdd\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u88ab\u4fdd\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u88ab\u4fdd\u4eba_2_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u88ab\u4fdd\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u88ab\u4fdd\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u88ab\u4fdd\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u88ab\u4fdd\u4eba_2_di_zhi_4\"}],\"\u5b66\u5386\":\"\u88ab\u4fdd\u4eba_2_xue_li\",\"\u56fd\u7c4d\":\"\u88ab\u4fdd\u4eba_2_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u88ab\u4fdd\u4eba_2_chu_sheng_ri_qi\"},{\"\u6027\u522b\":\"\u88ab\u4fdd\u4eba_3_xin_bie\",\"\u59d3\u540d\":\"\u88ab\u4fdd\u4eba_3_xin_ming\",\"\u53d7\u76ca\u4eba\":[{\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_2_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_2_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_2_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_2_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_2_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_2_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_2_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_2_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_2_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_2_chu_sheng_ri_qi\"},{\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_3_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_3_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_3_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_3_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_3_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_3_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_3_chu_sheng_ri_qi\"},{\"array3\":[[{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],[{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"test\":\"paramTest\",\"param\":\"param1\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"},{\"param\":\"param1\",\"test\":\"paramTest\",\"test2\":\"paramTest2\",\"test3\":\"paramTest3\"}],\"list_stringtest1\",\"list_stringtest2\",\"list_stringtest3\"],\"\u6027\u522b\":\"\u53d7\u76ca\u4eba_4_xin_bie\",\"\u59d3\u540d\":\"\u53d7\u76ca\u4eba_4_xin_ming\",\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_4_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_4_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_4_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_4_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u53d7\u76ca\u4eba_4_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u53d7\u76ca\u4eba_4_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u53d7\u76ca\u4eba_4_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u53d7\u76ca\u4eba_4_di_zhi_4\"}],\"\u5b66\u5386\":\"\u53d7\u76ca\u4eba_4_xue_li\",\"\u56fd\u7c4d\":\"\u53d7\u76ca\u4eba_4_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u53d7\u76ca\u4eba_4_chu_sheng_ri_qi\"}],\"\u5730\u5740\":[{\"\u5730\u5740\u4e8c\":\"\u88ab\u4fdd\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u88ab\u4fdd\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u88ab\u4fdd\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u88ab\u4fdd\u4eba_3_di_zhi_4\"},{\"\u5730\u5740\u4e8c\":\"\u88ab\u4fdd\u4eba_3_di_zhi_2\",\"\u5730\u5740\u4e00\":\"\u88ab\u4fdd\u4eba_3_di_zhi_1\",\"\u5730\u5740\u4e09\":\"\u88ab\u4fdd\u4eba_3_di_zhi_3\",\"\u5730\u5740\u56db\":\"\u88ab\u4fdd\u4eba_3_di_zhi_4\"}],\"\u5b66\u5386\":\"\u88ab\u4fdd\u4eba_3_xue_li\",\"\u56fd\u7c4d\":\"\u88ab\u4fdd\u4eba_3_guo_ji\",\"\u51fa\u751f\u65e5\u671f\":\"\u88ab\u4fdd\u4eba_3_chu_sheng_ri_qi\"}]}";
        String json = "{\n    \"agentCode\": \"8827056\",\n    \"realName\": \"\u9ec4\u5fd7\u82ac\",\n    \"gender\": \"F\",\n    \"birthday\": \"1971-12-16\",\n    \"certiType\": \"1\",\n    \"certiCode\": \"330922197112163521\",\n    \"organId\": \"1330902\",\n    \"deptId\": \"1451900089\",\n    \"familyAddress\": \"\u6d59\u6c5f\u7701\u821f\u5c71\u5e02\u5b9a\u6d77\u533a\u6a80\u4e1c\u9890\u666f\u56ed40\u5e62303\u5ba4\",\n    \"telephone\": \"\",\n    \"cellerTel\": \"13464832332\",\n    \"email\": \"\",\n    \"recommendManId\": \"\",\n    \"gradeId\": \"304\",\n    \"enterCompanyDate\": \"2012-5-16\",\n    \"leaveCompanyDate\": \"2014-1-6\",\n    \"agentStatus\": \"2\",\n    \"probationDate\": \"2012-5-16\",\n    \"turnDate\": \"2014/1/6 16:01:19\",\n    \"agentCate\": \"4\",\n    \"reenterFlag\": \"0\",\n    \"insertTime\": \"2014/1/6 16:01:19\",\n    \"initGradeId\": \"01\",\n    \"greenPassport\": \"N\",\n    \"agentSubCate\": \"\",\n    \"trainManId\": \"0000001\",\n    \"indirectTrainId\": \"\",\n    \"deptTrainId\": \"0000001\",\n    \"indDeptTrainId\": \"0000001\",\n    \"areaTrainId\": \"0000001\",\n    \"indAreaTrainId\": \"0000001\",\n    \"trainIdValid\": \"0000001\",\n    \"indiTrainIdValid\": \"0000001\",\n    \"deptTrainIdValid\": \"0000001\",\n    \"indiDeptTrainIdValid\": \"0000001\",\n    \"areaTrainIdValid\": \"0000001\",\n    \"indiAreaTrainIdValid\": \"0000001\",\n    \"qualificationId\": \"0000001\",\n    \"practiceId\": \"0000001\",\n    \"outAgentCode\": \"\",\n    \"outOrganID\": \"\",\n    \"villageId\": \"0000001\",\n    \"agencyCode\": \"19420070\",\n    \"qualificationStartDate\": \"2012/6/1\",\n    \"qualificationEndDate\": \"2012/6/1\",\n    \"laborForm\": \"2\",\n    \"gradeName\": \"\",\n    \"versionId\": \"\",\n    \"updateTime\": \"2015-10-27 15:07:47\"\n}";
        long start = System.currentTimeMillis();
        Map<String, Object> map = JsonUtilOld.json2Map(json);
        long end = System.currentTimeMillis();
        System.out.println("\u8f6cjson=" + (end - start));
        start = System.currentTimeMillis();
        JsonUtilOld.toLowerCaseMap(map);
        end = System.currentTimeMillis();
        System.out.println("map key\u8f6c\u5c0f\u5199=" + (end - start));
        HashMap<String, Date> map_date = new HashMap<String, Date>();
        map_date.put("crt_timestamp", DateUtil.sysTimestamp());
        map_date.put("crtDate", DateUtil.sysDate());
        map_date.put("crttime", DateUtil.sysTime());
        System.out.println(JsonUtilOld.formatJSONObject(map_date));
    }

    public static Map<String, Object> toLowerCaseMap(Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            param.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return param;
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> cla) {
        try {
            T t = cla.newInstance();
            List fields = ClassUtil.getClassFields(cla);
            for (Field field : fields) {
                Object obj = map.get(field.getName());
                if (obj == null) continue;
                Class<?> classType = field.getType();
                field.setAccessible(true);
                if (classType == List.class) {
                    Class genericityClass = ClassUtil.getFieldGenericity((Field)field);
                    if (genericityClass == null || ClassUtil.isBaseType(classType)) {
                        field.set(t, obj);
                        continue;
                    }
                    field.set(t, JsonUtilOld.mapToListObj((List)obj, genericityClass));
                    continue;
                }
                if (ClassUtil.isBaseType(classType)) {
                    field.set(t, obj);
                    continue;
                }
                if (obj instanceof Map || obj instanceof HashMap) {
                    Object returnObj = JsonUtilOld.mapToObject((Map)obj, classType);
                    field.set(t, returnObj);
                    continue;
                }
                field.set(t, obj);
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> mapToListObj(List<Map<String, Object>> list, Class<T> cla) {
        try {
            ArrayList<T> returnList = new ArrayList<T>();
            for (Map<String, Object> map : list) {
                T t = JsonUtilOld.mapToObject(map, cla);
                returnList.add(t);
            }
            return returnList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> objToMap(Object obj) {
        String json = "";
        HashMap<String, Object> map = new HashMap();
        try {
            ObjectMapper mapper = JsonUtilOld.initObjectMapper();
            json = mapper.writeValueAsString(obj);
            map = JsonUtilOld.json2Map(json);
            return map;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

